/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfxsltrunner;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.odftoolkit.odfxsltrunner.CommandLineLogger;
import org.odftoolkit.odfxsltrunner.Logger;
import org.odftoolkit.odfxsltrunner.ODFXSLTRunner;
import org.odftoolkit.odfxsltrunner.XSLTCommandLineParameter;

public class Main {
    private static final String VERSION = "1.1.0";

    public static void main(String[] aArgs) {
        String aStyleSheetName = null;
        String aInputName = null;
        String aOutputName = null;
        String aPath = "content.xml";
        String aLogFileName = null;
        String aTransformerFactoryClass = null;
        int aInputMode = 1;
        int aOutputMode = 3;
        Vector<XSLTCommandLineParameter> aParams = null;
        Vector<String> aExtractFileNames = null;
        int nLogLevel = 0;
        boolean bCommandLineValid = true;
        List<String> aArgList = Arrays.asList(aArgs);
        Iterator<String> aArgIter = aArgList.iterator();
        while (aArgIter.hasNext() && bCommandLineValid) {
            String aArg = aArgIter.next();
            if (aArg.equals("-f")) {
                if (aArgIter.hasNext()) {
                    aTransformerFactoryClass = aArgIter.next();
                    continue;
                }
                bCommandLineValid = false;
                continue;
            }
            if (aArg.equals("-i")) {
                aInputMode = 0;
                continue;
            }
            if (aArg.equals("-l")) {
                if (aArgIter.hasNext()) {
                    aLogFileName = aArgIter.next();
                    continue;
                }
                bCommandLineValid = false;
                continue;
            }
            if (aArg.equals("-o")) {
                if (aOutputMode == 3) {
                    aOutputMode = 0;
                    continue;
                }
                bCommandLineValid = false;
                continue;
            }
            if (aArg.equals("-p")) {
                if (aArgIter.hasNext()) {
                    aPath = aArgIter.next();
                    continue;
                }
                bCommandLineValid = false;
                continue;
            }
            if (aArg.equals("-r")) {
                if (aOutputMode == 3) {
                    aOutputMode = 2;
                    continue;
                }
                bCommandLineValid = false;
                continue;
            }
            if (aArg.equals("-t")) {
                if (aOutputMode == 3) {
                    aOutputMode = 4;
                    continue;
                }
                bCommandLineValid = false;
                continue;
            }
            if (aArg.equals("-v")) {
                nLogLevel = 2;
                continue;
            }
            if (aArg.equals("-x")) {
                if (aArgIter.hasNext()) {
                    if (aExtractFileNames == null) {
                        aExtractFileNames = new Vector<String>();
                    }
                    aExtractFileNames.add(aArgIter.next());
                    continue;
                }
                bCommandLineValid = false;
                continue;
            }
            if (aArg.startsWith("-")) {
                System.out.print(aArg);
                System.out.println(": unknown option, use '-' for help");
                bCommandLineValid = false;
                break;
            }
            if (aStyleSheetName == null) {
                aStyleSheetName = aArg;
                continue;
            }
            if (aInputName == null) {
                aInputName = aArg;
                continue;
            }
            if (aOutputMode != 2 && aOutputName == null) {
                aOutputName = aArg;
                continue;
            }
            if (aArg.indexOf(61) != -1) {
                if (aParams == null) {
                    aParams = new Vector<XSLTCommandLineParameter>();
                }
                aParams.add(new XSLTCommandLineParameter(aArg));
                continue;
            }
            bCommandLineValid = false;
            break;
        }
        if (aOutputMode == 3 && aOutputName == null) {
            aOutputMode = 1;
        }
        boolean bl = bCommandLineValid = aInputName != null && aStyleSheetName != null;
        boolean bl2 = bCommandLineValid && (aOutputMode != 2 && aOutputMode != 1) == (aOutputName != null) ? true : (bCommandLineValid = false);
        if (!bCommandLineValid) {
            Main.printUsage();
            return;
        }
        PrintStream aLogStream = null;
        if (aLogFileName != null) {
            try {
                aLogStream = new PrintStream(aLogFileName);
            }
            catch (FileNotFoundException e) {
                System.err.println(e.getMessage());
            }
        }
        boolean bError = false;
        try {
            ODFXSLTRunner aRunner = new ODFXSLTRunner();
            CommandLineLogger aLogger = new CommandLineLogger(aLogStream != null ? aLogStream : System.err, nLogLevel);
            bError = aRunner.runXSLT(aStyleSheetName, aParams, aInputName, aInputMode, aOutputName, aOutputMode, aPath, aTransformerFactoryClass, aExtractFileNames, (Logger)aLogger);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        if (aLogStream != null) {
            aLogStream.close();
        }
    }

    private static void printUsage() {
        System.out.print("odfxsltrunner v");
        System.out.println(VERSION);
        System.out.println();
        System.out.println("usage: odfxsltrunner <style sheet> [-v] [-f <factory>] [-p <path in package>] [-l log file] [-t] <input package> <output package> {<param>=<value>}");
        System.out.println("       odfxsltrunner <style sheet> [-v] [-f <factory>] [-p <path in package>] [-l log file] -r <package> {<param>=<value>}");
        System.out.println("       odfxsltrunner <style sheet> [-v] [-f <factory>] {-x <export path>} [-p <path in package>] [-l log file] -o <input package> <output file> {<param>=<value>}");
        System.out.println("       odfxsltrunner <style sheet> [-v] [-f <factory>] [-p <path in package>] [-l log file] -i <input file> <output package> {<param>=<value>}");
        System.out.println();
        System.out.println("If no option except -p is specified, the transformation <style sheet> is applied to the file <path in package> contained in the ODF  package <input package>, <path in package> is replaced with the result of the transformation, and the full package is stored as <output package>.");
        System.out.println();
        System.out.println("-t: Store result of transformation in the file <path in package> of existing an existing ODF package <output package>");
        System.out.println("-r: Don't store result as a new ODF package but replace input ODF package <package>");
        System.out.println("-i: Input file <input file> is a plain XML file");
        System.out.println("-o: Store result of tranformation as plain XML file in <output file>");
        System.out.println();
        System.out.println("-l: Write messages into file <log file> instead of stderr");
        System.out.println("-p: Apply style sheet to <path in package>; default is content.xml");
        System.out.println("-f: Use XSLT Transformer factory <factory>");
        System.out.println();
        System.out.println("-x: Extract specified file or directory <export path> from ODF package <input package> to the directory of the <output file>; this option may be specified multiple times");
        System.out.println("-v: Verbose output");
        System.out.println();
        System.out.println("<param>=<value>: Specifies an parameter/value pair that is passed to the XSL transformation; multiple paramater/vlaue pairs may be specified");
    }
}

