/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.text.list;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.element.style.StyleListLevelPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.text.TextListElement;
import org.odftoolkit.odfdom.dom.element.text.TextListItemElement;
import org.odftoolkit.odfdom.dom.element.text.TextListLevelStyleBulletElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextListStyle;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.text.list.List;
import org.odftoolkit.simple.text.list.ListDecorator;
import org.odftoolkit.simple.text.list.ListItem;
import org.w3c.dom.Node;

public class BulletDecorator
implements ListDecorator {
    private static String[] DEFAULT_TEXT_SPACE_BEFORE_ATTRIBUTES = new String[]{null, "0.401cm", "0.799cm", "1.2cm", "1.6cm", "2.001cm", "2.399cm", "2.8cm", "3.2cm", "3.601cm"};
    private static String DEFAULT_TEXT_MIN_LABEL_WIDTH = "0.4cm";
    private static String DEFAULT_FONT_NAME = "Tahoma";
    private static String DEFAULT_NAME = "Simple_Default_Bullet_List";
    private OdfTextListStyle listStyle;
    private OdfStyle paragraphStyle;
    private OdfOfficeAutomaticStyles styles;

    public BulletDecorator(Document doc) {
        try {
            OdfContentDom contentDocument = doc.getContentDom();
            this.styles = contentDocument.getAutomaticStyles();
            OdfOfficeStyles documentStyles = doc.getDocumentStyles();
            this.listStyle = this.styles.getListStyle(DEFAULT_NAME);
            if (this.listStyle == null) {
                this.listStyle = this.styles.newListStyle();
                this.getOrCreateStyleByName(documentStyles, this.styles, "Bullet_20_Symbols", OdfStyleFamily.Text);
                for (int i = 0; i < 10; ++i) {
                    TextListLevelStyleBulletElement listLevelElement = this.listStyle.newTextListLevelStyleBulletElement("\u25e6", i + 1);
                    listLevelElement.setTextStyleNameAttribute("Bullet_20_Symbols");
                    StyleListLevelPropertiesElement styleListLevelPropertiesElement = listLevelElement.newStyleListLevelPropertiesElement();
                    if (DEFAULT_TEXT_SPACE_BEFORE_ATTRIBUTES[i] != null) {
                        styleListLevelPropertiesElement.setTextSpaceBeforeAttribute(DEFAULT_TEXT_SPACE_BEFORE_ATTRIBUTES[i]);
                    }
                    styleListLevelPropertiesElement.setTextMinLabelWidthAttribute(DEFAULT_TEXT_MIN_LABEL_WIDTH);
                    StyleTextPropertiesElement styleTextPropertiesElement = listLevelElement.newStyleTextPropertiesElement("true");
                    styleTextPropertiesElement.setStyleFontNameAttribute(DEFAULT_FONT_NAME);
                }
            }
            this.paragraphStyle = this.styles.newStyle(OdfStyleFamily.Paragraph);
            this.getOrCreateStyleByName(documentStyles, this.styles, "Default_20_Text", OdfStyleFamily.Paragraph);
            this.paragraphStyle.setStyleParentStyleNameAttribute("Default_20_Text");
            this.paragraphStyle.setStyleListStyleNameAttribute(this.listStyle.getStyleNameAttribute());
        }
        catch (Exception e) {
            Logger.getLogger(BulletDecorator.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    @Override
    public void decorateList(List list) {
        TextListElement listElement = list.getOdfElement();
        listElement.setTextStyleNameAttribute(this.listStyle.getStyleNameAttribute());
    }

    @Override
    public void decorateListItem(ListItem item) {
        TextListItemElement listItemElement = item.getOdfElement();
        for (Node child = listItemElement.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof TextPElement)) continue;
            TextPElement pElement = (TextPElement)child;
            pElement.setTextStyleNameAttribute(this.paragraphStyle.getStyleNameAttribute());
        }
    }

    @Override
    public ListDecorator.ListType getListType() {
        return ListDecorator.ListType.BULLET;
    }

    private OdfStyle getOrCreateStyleByName(OdfOfficeStyles documentStyles, OdfOfficeAutomaticStyles styles, String styleName, OdfStyleFamily styleFamily) {
        OdfStyle odfStyle = documentStyles.getStyle(styleName, styleFamily);
        if (odfStyle == null) {
            styles.getStyle(styleName, styleFamily);
        }
        if (odfStyle == null) {
            odfStyle = styles.newStyle(styleFamily);
            odfStyle.setStyleNameAttribute(styleName);
            odfStyle.setStyleDisplayNameAttribute(styleName);
        }
        return odfStyle;
    }
}

