/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.table;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnGroupElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableHeaderColumnsElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfTableColumnProperties;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.NamespaceName;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.pkg.OdfXMLFactory;
import org.odftoolkit.odfdom.type.Length;
import org.odftoolkit.odfdom.type.PositiveLength;
import org.odftoolkit.simple.Component;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.SpreadsheetDocument;
import org.odftoolkit.simple.table.Cell;
import org.odftoolkit.simple.table.DomNodeList;
import org.odftoolkit.simple.table.Table;
import org.w3c.dom.Node;

public class Column
extends Component {
    TableTableColumnElement maColumnElement;
    int mnRepeatedIndex;
    private static final String DEFAULT_WIDTH = "0in";
    private final int DEFAULT_REL_TABLE_WIDTH = 65535;
    private Document mDocument;

    Column(TableTableColumnElement colElement, int repeatedIndex) {
        this.maColumnElement = colElement;
        this.mnRepeatedIndex = repeatedIndex;
        this.mDocument = (Document)((OdfFileDom)this.maColumnElement.getOwnerDocument()).getDocument();
    }

    public static Column getInstance(TableTableColumnElement colElement) {
        TableTableElement tableElement = null;
        for (Node node = colElement.getParentNode(); node != null; node = node.getParentNode()) {
            if (!(node instanceof TableTableElement)) continue;
            tableElement = (TableTableElement)node;
        }
        Table table = null;
        if (tableElement == null) {
            throw new IllegalArgumentException("the colElement is not in the table dom tree");
        }
        table = Table.getInstance(tableElement);
        Column column = table.getColumnInstance(colElement, 0);
        if (column.getColumnsRepeatedNumber() > 1) {
            Logger.getLogger(Column.class.getName()).log(Level.WARNING, "the column has the repeated column number, and puzzled about get which repeated index of the column,here just return the first column of the repeated columns.");
        }
        return column;
    }

    private TableTableElement getTableElement() {
        for (Node node = this.maColumnElement.getParentNode(); node != null; node = node.getParentNode()) {
            if (!(node instanceof TableTableElement)) continue;
            return (TableTableElement)node;
        }
        return null;
    }

    public Table getTable() {
        TableTableElement tableElement = this.getTableElement();
        if (tableElement != null) {
            return Table.getInstance(tableElement);
        }
        return null;
    }

    public double getWidth() {
        String sWidth = this.maColumnElement.getProperty(OdfTableColumnProperties.ColumnWidth);
        if (sWidth == null) {
            sWidth = DEFAULT_WIDTH;
        }
        return PositiveLength.parseDouble((String)sWidth, (Length.Unit)Length.Unit.MILLIMETER);
    }

    public void setWidthWidthoutRelative(double width) {
        double roundingFactor = 10000.0;
        double inValue = (double)Math.round(roundingFactor * width / Length.Unit.INCH.unitInMillimiter()) / roundingFactor;
        String sWidthIN = String.valueOf(inValue) + Length.Unit.INCH.abbr();
        this.splitRepeatedColumns();
        this.maColumnElement.setProperty(OdfTableColumnProperties.ColumnWidth, sWidthIN);
        Table table = this.getTable();
    }

    public void setWidth(double width) {
        double roundingFactor = 10000.0;
        double inValue = (double)Math.round(roundingFactor * width / Length.Unit.INCH.unitInMillimiter()) / roundingFactor;
        String sWidthIN = String.valueOf(inValue) + Length.Unit.INCH.abbr();
        double columnWidth = this.getWidth();
        if (columnWidth < 0.0) {
            columnWidth = 0.0;
        }
        this.splitRepeatedColumns();
        this.maColumnElement.setProperty(OdfTableColumnProperties.ColumnWidth, sWidthIN);
        Table table = this.getTable();
        if (!(table.getOwnerDocument() instanceof SpreadsheetDocument)) {
            int columnCount;
            int index = this.getColumnIndex();
            index = index == (columnCount = table.getColumnCount()) - 1 ? --index : ++index;
            if (index >= 0) {
                double columnsWidth;
                double newWidthNextColumn;
                Column column = null;
                if (index < columnCount) {
                    column = table.getColumnByIndex(index);
                } else if (columnCount >= 2) {
                    column = table.getColumnByIndex(columnCount - 2);
                }
                double nextColumnWidth = 0.0;
                if (column != null) {
                    nextColumnWidth = column.getWidth();
                    this.setRelativeWidth((long)(65535.0 / table.getWidth() * width));
                }
                if ((newWidthNextColumn = (columnsWidth = nextColumnWidth + columnWidth) - width) < 0.0) {
                    newWidthNextColumn = 0.0;
                }
                inValue = (double)Math.round(roundingFactor * newWidthNextColumn / Length.Unit.INCH.unitInMillimiter()) / roundingFactor;
                sWidthIN = String.valueOf(inValue) + Length.Unit.INCH.abbr();
                column.getOdfElement().setProperty(OdfTableColumnProperties.ColumnWidth, sWidthIN);
                double relWidth = 65535.0 / table.getWidth() * newWidthNextColumn;
                column.setRelativeWidth((long)relWidth);
            }
        }
    }

    void splitRepeatedColumns() {
        Table table = this.getTable();
        TableTableElement tableEle = table.getOdfElement();
        int repeateNum = this.getColumnsRepeatedNumber();
        if (repeateNum > 1) {
            TableTableColumnElement ownerColumnElement = null;
            String columnWidthStr = null;
            long columnWidth = 0L;
            int repeatedColumnIndex = this.mnRepeatedIndex;
            TableTableColumnElement refElement = this.maColumnElement;
            this.maColumnElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated");
            String originalWidth = this.maColumnElement.getProperty(OdfTableColumnProperties.ColumnWidth);
            String originalRelWidth = this.maColumnElement.getProperty(OdfTableColumnProperties.RelColumnWidth);
            if (originalWidth != null) {
                columnWidthStr = Length.mapToUnit((String)originalWidth, (Length.Unit)Length.Unit.MILLIMETER);
                columnWidth = PositiveLength.parseLong((String)columnWidthStr, (Length.Unit)Length.Unit.MILLIMETER);
            }
            for (int i = repeateNum - 1; i >= 0; --i) {
                TableTableColumnElement newColumn = (TableTableColumnElement)OdfXMLFactory.newOdfElement((OdfFileDom)((OdfFileDom)this.maColumnElement.getOwnerDocument()), (OdfName)OdfName.newName((NamespaceName)OdfDocumentNamespace.TABLE, (String)"table-column"));
                if (originalWidth != null && originalWidth.length() > 0) {
                    newColumn.setProperty(OdfTableColumnProperties.ColumnWidth, originalWidth);
                }
                if (originalRelWidth != null && originalRelWidth.length() > 0) {
                    long relWidth = (long)(65535.0 / table.getWidth() * (double)columnWidth);
                    newColumn.setProperty(OdfTableColumnProperties.RelColumnWidth, String.valueOf(relWidth) + "*");
                }
                tableEle.insertBefore((Node)newColumn, (Node)refElement);
                refElement = newColumn;
                if (repeatedColumnIndex == i) {
                    ownerColumnElement = newColumn;
                    continue;
                }
                table.updateColumnRepository(this.maColumnElement, i, newColumn, 0);
            }
            tableEle.removeChild((Node)this.maColumnElement);
            if (ownerColumnElement != null) {
                table.updateColumnRepository(this.maColumnElement, this.mnRepeatedIndex, ownerColumnElement, 0);
                this.maColumnElement = ownerColumnElement;
            }
        }
    }

    private void setRelativeWidth(long relWidth) {
        if (relWidth < 40L) {
            this.maColumnElement.setProperty(OdfTableColumnProperties.RelColumnWidth, String.valueOf(40) + "*");
        } else {
            this.maColumnElement.setProperty(OdfTableColumnProperties.RelColumnWidth, String.valueOf(relWidth) + "*");
        }
    }

    public boolean isOptimalWidth() {
        return Boolean.parseBoolean(this.maColumnElement.getProperty(OdfTableColumnProperties.UseOptimalColumnWidth));
    }

    public void setUseOptimalWidth(boolean isUseOptimalWidth) {
        this.maColumnElement.setProperty(OdfTableColumnProperties.UseOptimalColumnWidth, String.valueOf(isUseOptimalWidth));
    }

    public TableTableColumnElement getOdfElement() {
        return this.maColumnElement;
    }

    public int getCellCount() {
        return this.getTable().getRowCount();
    }

    public Cell getCellByIndex(int index) {
        return this.getTable().getCellByPosition(this.getColumnIndex(), index);
    }

    public Column getPreviousColumn() {
        Table table = this.getTable();
        if (this.maColumnElement.getTableNumberColumnsRepeatedAttribute() > 1 && this.mnRepeatedIndex > 0) {
            return table.getColumnInstance(this.maColumnElement, this.mnRepeatedIndex - 1);
        }
        Node aPrevNode = this.maColumnElement.getPreviousSibling();
        Object aCurNode = this.maColumnElement;
        while (true) {
            if (aPrevNode == null) {
                Node parentNode = aCurNode.getParentNode();
                if (parentNode instanceof TableTableElement) {
                    return null;
                }
                aPrevNode = parentNode.getPreviousSibling();
            }
            if (aPrevNode == null) continue;
            try {
                if (aPrevNode instanceof TableTableColumnElement) {
                    return table.getColumnInstance((TableTableColumnElement)aPrevNode, ((TableTableColumnElement)aPrevNode).getTableNumberColumnsRepeatedAttribute() - 1);
                }
                if (aPrevNode instanceof TableTableColumnsElement || aPrevNode instanceof TableTableHeaderColumnsElement || aPrevNode instanceof TableTableColumnGroupElement) {
                    XPath xpath = ((OdfFileDom)this.maColumnElement.getOwnerDocument()).getXPath();
                    TableTableColumnElement lastCol = (TableTableColumnElement)xpath.evaluate("//table:table-column[last()]", aPrevNode, XPathConstants.NODE);
                    if (lastCol == null) continue;
                    return table.getColumnInstance(lastCol, lastCol.getTableNumberColumnsRepeatedAttribute() - 1);
                }
                aCurNode = aPrevNode;
                aPrevNode = aPrevNode.getPreviousSibling();
                continue;
            }
            catch (XPathExpressionException e) {
                Logger.getLogger(Column.class.getName()).log(Level.SEVERE, e.getMessage(), e);
                continue;
            }
            break;
        }
    }

    public Column getNextColumn() {
        Table table = this.getTable();
        int columnsRepeatedNumber = this.getColumnsRepeatedNumber();
        if (columnsRepeatedNumber > 1 && this.mnRepeatedIndex < columnsRepeatedNumber - 1) {
            return table.getColumnInstance(this.maColumnElement, this.mnRepeatedIndex + 1);
        }
        Node aNextNode = this.maColumnElement.getNextSibling();
        Object aCurNode = this.maColumnElement;
        while (true) {
            if (aNextNode == null) {
                Node parentNode = aCurNode.getParentNode();
                if (parentNode instanceof TableTableElement) {
                    return null;
                }
                aNextNode = parentNode.getNextSibling();
            }
            if (aNextNode == null) continue;
            try {
                if (aNextNode instanceof TableTableColumnElement) {
                    return table.getColumnInstance((TableTableColumnElement)aNextNode, 0);
                }
                if (aNextNode instanceof TableTableColumnsElement || aNextNode instanceof TableTableHeaderColumnsElement || aNextNode instanceof TableTableColumnGroupElement) {
                    XPath xpath = ((OdfFileDom)this.maColumnElement.getOwnerDocument()).getXPath();
                    TableTableColumnElement firstCol = (TableTableColumnElement)xpath.evaluate("//table:table-column[first()]", aNextNode, XPathConstants.NODE);
                    if (firstCol == null) continue;
                    return table.getColumnInstance(firstCol, 0);
                }
                aCurNode = aNextNode;
                aNextNode = aNextNode.getNextSibling();
                continue;
            }
            catch (XPathExpressionException e) {
                Logger.getLogger(Column.class.getName()).log(Level.SEVERE, e.getMessage(), e);
                continue;
            }
            break;
        }
    }

    public int getColumnIndex() {
        int result = 0;
        Table table = this.getTable();
        TableTableElement mTableElement = table.getOdfElement();
        for (Node n : new DomNodeList(mTableElement.getChildNodes())) {
            TableTableColumnElement columnEle;
            if (n instanceof TableTableHeaderColumnsElement) {
                TableTableHeaderColumnsElement headers = (TableTableHeaderColumnsElement)n;
                for (Node m : new DomNodeList(headers.getChildNodes())) {
                    if (!(m instanceof TableTableColumnElement)) continue;
                    columnEle = (TableTableColumnElement)m;
                    if (columnEle == this.getOdfElement()) {
                        return result + this.mnRepeatedIndex;
                    }
                    if (columnEle.getTableNumberColumnsRepeatedAttribute() == null) {
                        ++result;
                        continue;
                    }
                    result += columnEle.getTableNumberColumnsRepeatedAttribute().intValue();
                }
            }
            if (!(n instanceof TableTableColumnElement)) continue;
            columnEle = (TableTableColumnElement)n;
            if (columnEle == this.getOdfElement()) break;
            if (columnEle.getTableNumberColumnsRepeatedAttribute() == null) {
                ++result;
                continue;
            }
            result += columnEle.getTableNumberColumnsRepeatedAttribute().intValue();
        }
        return result + this.mnRepeatedIndex;
    }

    public void setDefaultCellStyle(OdfStyle style) {
        this.splitRepeatedColumns();
        OdfStyle defaultStyle = this.getDefaultCellStyle();
        if (defaultStyle != null) {
            defaultStyle.removeStyleUser((OdfStylableElement)this.maColumnElement);
        }
        if (style != null) {
            style.addStyleUser((OdfStylableElement)this.maColumnElement);
            this.maColumnElement.setTableDefaultCellStyleNameAttribute(style.getStyleNameAttribute());
        }
    }

    public OdfStyle getDefaultCellStyle() {
        String styleName = this.maColumnElement.getTableDefaultCellStyleNameAttribute();
        OdfStyle style = this.maColumnElement.getAutomaticStyles().getStyle(styleName, OdfStyleFamily.TableCell);
        if (style == null) {
            style = this.mDocument.getDocumentStyles().getStyle(styleName, OdfStyleFamily.TableCell);
        }
        return style;
    }

    void setColumnsRepeatedNumber(int num) {
        this.maColumnElement.setTableNumberColumnsRepeatedAttribute(Integer.valueOf(num));
    }

    int getColumnsRepeatedNumber() {
        Integer count = this.maColumnElement.getTableNumberColumnsRepeatedAttribute();
        if (count == null) {
            return 1;
        }
        return count;
    }
}

