/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.text;

import java.net.URI;
import java.net.URISyntaxException;
import org.odftoolkit.odfdom.dom.element.text.TextAElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Component;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.text.Paragraph;

public class TextHyperlink
extends Component {
    TextAElement hyperLinkElement;
    private Document mOwnerDocument;

    private TextHyperlink(TextAElement aElement) {
        this.hyperLinkElement = aElement;
        this.mOwnerDocument = (Document)((OdfFileDom)this.hyperLinkElement.getOwnerDocument()).getDocument();
    }

    public static TextHyperlink getInstanceof(TextAElement aElement) {
        if (aElement == null) {
            return null;
        }
        TextHyperlink link = null;
        link = (TextHyperlink)Component.getComponentByElement((OdfElement)aElement);
        if (link != null) {
            return link;
        }
        link = new TextHyperlink(aElement);
        Component.registerComponent(link, (OdfElement)aElement);
        return link;
    }

    public OdfElement getOdfElement() {
        return this.hyperLinkElement;
    }

    public URI getURI() throws URISyntaxException {
        return new URI(this.hyperLinkElement.getXlinkHrefAttribute());
    }

    public void setURI(URI linkto) {
        this.hyperLinkElement.setXlinkHrefAttribute(linkto.toString());
    }

    public String getTextContent() {
        return Paragraph.getTextContent(this.getOdfElement());
    }

    public void setTextContent(String text) {
        Paragraph.removeTextContentImpl(this.getOdfElement());
        if (text != null && !text.equals("")) {
            Paragraph.appendTextElements(this.getOdfElement(), text, true);
        }
    }

    public void removeTextContent() {
        Paragraph.removeTextContentImpl(this.getOdfElement());
    }
}

