/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.text;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.element.text.TextSectionElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Component;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.text.AbstractParagraphContainer;
import org.odftoolkit.simple.text.Paragraph;
import org.odftoolkit.simple.text.ParagraphContainer;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Section
extends Component
implements ParagraphContainer {
    private ParagraphContainerImpl paragraphContainerImpl;
    TextSectionElement mSectionElement;
    Document mDocument;

    private Section(Document doc, TextSectionElement element) {
        this.mSectionElement = element;
        this.mDocument = doc;
    }

    public static Section getInstance(TextSectionElement element) {
        return new Section((Document)((OdfFileDom)element.getOwnerDocument()).getDocument(), element);
    }

    @Override
    public Document getOwnerDocument() {
        return this.mDocument;
    }

    public String getName() {
        return this.mSectionElement.getTextNameAttribute();
    }

    public void setName(String name) {
        this.mSectionElement.setTextNameAttribute(name);
    }

    public void remove() {
        this.mDocument.removeElementLinkedResource((OdfElement)this.mSectionElement);
        this.mSectionElement.getParentNode().removeChild((Node)this.mSectionElement);
    }

    public TextSectionElement getOdfElement() {
        return this.mSectionElement;
    }

    boolean isInHeaderFooter() {
        try {
            if (this.mSectionElement.getOwnerDocument() == this.mDocument.getStylesDom()) {
                return true;
            }
        }
        catch (Exception e) {
            Logger.getLogger(Section.class.getName()).log(Level.SEVERE, "Failed in isInHeaderFooter", e);
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Section)) {
            return false;
        }
        Section aSection = (Section)obj;
        if (aSection == this) {
            return true;
        }
        return aSection.getOdfElement().equals((Object)this.mSectionElement);
    }

    @Override
    public Paragraph addParagraph(String textContent) {
        return this.getParagraphContainerImpl().addParagraph(textContent);
    }

    @Override
    public OdfElement getParagraphContainerElement() {
        return this.getParagraphContainerImpl().getParagraphContainerElement();
    }

    @Override
    public boolean removeParagraph(Paragraph para) {
        return this.getParagraphContainerImpl().removeParagraph(para);
    }

    private ParagraphContainerImpl getParagraphContainerImpl() {
        if (this.paragraphContainerImpl == null) {
            this.paragraphContainerImpl = new ParagraphContainerImpl();
        }
        return this.paragraphContainerImpl;
    }

    @Override
    public Paragraph getParagraphByIndex(int index, boolean isEmptyParagraphSkipped) {
        return this.getParagraphContainerImpl().getParagraphByIndex(index, isEmptyParagraphSkipped);
    }

    @Override
    public Paragraph getParagraphByReverseIndex(int reverseIndex, boolean isEmptyParagraphSkipped) {
        return this.getParagraphContainerImpl().getParagraphByReverseIndex(reverseIndex, isEmptyParagraphSkipped);
    }

    @Override
    public Iterator<Paragraph> getParagraphIterator() {
        return this.getParagraphContainerImpl().getParagraphIterator();
    }

    private class ParagraphContainerImpl
    extends AbstractParagraphContainer {
        private ParagraphContainerImpl() {
        }

        public OdfElement getParagraphContainerElement() {
            return Section.this.mSectionElement;
        }
    }
}

