/*
 * Decompiled with CFR 0.152.
 */
package schema2template.model;

import com.sun.msv.grammar.Expression;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.msv.reader.trex.ng.RELAXNGReader;
import com.sun.msv.reader.util.IgnoreController;
import com.sun.msv.reader.xmlschema.XMLSchemaReader;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.xml.parsers.SAXParserFactory;
import schema2template.model.PuzzlePiece;
import schema2template.model.PuzzlePieceSet;
import schema2template.model.QNamed;
import schema2template.model.QNamedPuzzleComponent;

public class XMLModel {
    PuzzlePieceSet mElements = new PuzzlePieceSet();
    PuzzlePieceSet mAttributes = new PuzzlePieceSet();
    Map<String, PuzzlePiece> mNameElementMap;
    Map<String, PuzzlePiece> mNameAttributeMap;
    public Expression mRootExpression;
    public String mLastSchemaFileName;

    public XMLModel(File schemaFile) {
        this.mRootExpression = XMLModel.loadSchema(schemaFile);
        String absolutePath = schemaFile.getAbsolutePath();
        this.mLastSchemaFileName = absolutePath.substring(absolutePath.lastIndexOf(File.separatorChar) + 1, absolutePath.length());
        PuzzlePiece.extractPuzzlePieces(this.mRootExpression, this.mElements, this.mAttributes, this.mLastSchemaFileName);
        this.mElements.makeImmutable();
        this.mAttributes.makeImmutable();
        this.mNameElementMap = XMLModel.createMap(this.mElements);
        this.mNameAttributeMap = XMLModel.createMap(this.mAttributes);
    }

    private static Map<String, PuzzlePiece> createMap(Collection<PuzzlePiece> definitions) {
        HashMap<String, PuzzlePiece> retval = new HashMap<String, PuzzlePiece>();
        for (PuzzlePiece def : definitions) {
            retval.put(def.getQName(), def);
        }
        return retval;
    }

    static Map<String, SortedSet<PuzzlePiece>> createDefinitionMap(Collection<PuzzlePiece> definitions) {
        HashMap<String, SortedSet<PuzzlePiece>> retval = new HashMap<String, SortedSet<PuzzlePiece>>();
        for (PuzzlePiece def : definitions) {
            TreeSet<PuzzlePiece> multiples = (TreeSet<PuzzlePiece>)retval.get(def.getQName());
            if (multiples == null) {
                multiples = new TreeSet<PuzzlePiece>();
                retval.put(def.getQName(), multiples);
            }
            multiples.add(def);
        }
        return retval;
    }

    public static Expression loadSchema(File rngFile) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        IgnoreController ignoreController = new IgnoreController();
        String absolutePath = rngFile.getAbsolutePath();
        Expression root = null;
        if (absolutePath.endsWith(".rng")) {
            root = RELAXNGReader.parse((String)absolutePath, (SAXParserFactory)factory, (GrammarReaderController)ignoreController).getTopLevel();
        } else if (absolutePath.endsWith(".xsd")) {
            root = XMLSchemaReader.parse((String)absolutePath, (SAXParserFactory)factory, (GrammarReaderController)ignoreController).getTopLevel();
        } else {
            throw new RuntimeException("Reader not chosen for given schema suffix!");
        }
        if (root == null) {
            throw new RuntimeException("Schema could not be parsed.");
        }
        return root;
    }

    public PuzzlePieceSet getElements() {
        return this.mElements;
    }

    public PuzzlePieceSet getAttributes() {
        return this.mAttributes;
    }

    public QNamedPuzzleComponent getElement(String name) {
        PuzzlePiece element = this.mNameElementMap.get(name);
        if (element == null) {
            return null;
        }
        return element.withMultiples();
    }

    public PuzzlePiece getElement(String name, int hashCode) {
        PuzzlePiece element = this.mNameElementMap.get(name);
        if (element == null) {
            return null;
        }
        for (PuzzlePiece def : element.withMultiples()) {
            if (def.hashCode() != hashCode) continue;
            return def;
        }
        return null;
    }

    public QNamedPuzzleComponent getAttribute(String name) {
        PuzzlePiece attribute = this.mNameAttributeMap.get(name);
        if (attribute == null) {
            return null;
        }
        return attribute.withMultiples();
    }

    public PuzzlePiece getAttribute(String name, int hashCode) {
        PuzzlePiece attribute = this.mNameAttributeMap.get(name);
        if (attribute == null) {
            return null;
        }
        for (PuzzlePiece def : attribute.withMultiples()) {
            if (def.hashCode() != hashCode) continue;
            return def;
        }
        return null;
    }

    public static String camelCase(String raw) {
        StringTokenizer tok = new StringTokenizer(raw, "-:/ _.,");
        Object retval = "";
        while (tok.hasMoreElements()) {
            String word = tok.nextToken();
            if (word.equals("")) continue;
            retval = (String)retval + word.substring(0, 1).toUpperCase() + word.substring(1);
        }
        return retval;
    }

    public static String camelCase(QNamed def) {
        return XMLModel.camelCase(def.getQName());
    }

    public static String javaCase(String raw) {
        String retval = XMLModel.camelCase(raw);
        if (retval.length() > 0) {
            retval = retval.substring(0, 1).toLowerCase().concat(retval.substring(1));
        }
        return retval;
    }

    public static String javaCase(QNamed def) {
        return XMLModel.javaCase(def.getQName());
    }

    public static String constantCase(String raw) {
        StringTokenizer tok = new StringTokenizer(raw, "-:/ _.,");
        Object retval = "";
        String separator = "";
        while (tok.hasMoreElements()) {
            String word = tok.nextToken();
            if (word.equals("")) continue;
            retval = (String)retval + separator + word.toUpperCase();
            separator = "_";
        }
        return retval;
    }

    public static String constantCase(QNamed def) {
        return XMLModel.constantCase(def.getQName());
    }

    public static String firstWord(String raw) {
        StringTokenizer tok = new StringTokenizer(raw, "-:/ _.,");
        if (tok.hasMoreElements()) {
            return tok.nextToken();
        }
        return null;
    }

    public static String firstWord(QNamed def) {
        return XMLModel.firstWord(def.getQName());
    }

    public static String lastWord(String raw) {
        StringTokenizer tok = new StringTokenizer(raw, "-:/ _.,");
        String retval = null;
        while (tok.hasMoreElements()) {
            retval = tok.nextToken();
        }
        return retval;
    }

    public static String lastWord(QNamed def) {
        return XMLModel.lastWord(def.getQName());
    }

    public static String escapeKeyword(QNamed in) {
        return XMLModel.escapeKeyword(in.getQName());
    }

    public static String escapeKeyword(String in) {
        if (in == null || in.length() == 0) {
            return in;
        }
        Object out = in;
        if (((String)out).substring(0, 1).matches("^\\p{Digit}")) {
            out = "_" + (String)out;
        }
        return out;
    }

    public static String escapeLiteral(QNamed in) {
        return XMLModel.escapeLiteral(in.getQName());
    }

    public static String escapeLiteral(String in) {
        if (in == null || in.length() == 0) {
            return in;
        }
        String out = in;
        out = out.replaceAll("\"", "\\\\\"");
        return out;
    }

    public static String extractNamespace(String name) {
        int pos = name.lastIndexOf(":");
        if (pos > 0 && pos < name.length() - 1) {
            return name.substring(0, pos);
        }
        return null;
    }

    public static String extractNamespace(QNamed def) {
        return XMLModel.extractNamespace(def.getQName());
    }

    public static String extractLocalname(String name) {
        int pos = name.lastIndexOf(":");
        if (pos > 0 && pos < name.length() - 1) {
            return name.substring(pos + 1);
        }
        return null;
    }

    public static String extractLocalname(QNamed def) {
        return XMLModel.extractLocalname(def.getQName());
    }
}

