/*
 * Decompiled with CFR 0.152.
 */
package schema2template.grammar;

import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionVisitor;
import com.sun.msv.grammar.NameClassAndExpression;
import com.sun.msv.grammar.OneOrMoreExp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import schema2template.SchemaToTemplate;
import schema2template.grammar.MSVExpressionType;
import schema2template.grammar.PathPrinter;
import schema2template.grammar.PuzzlePiece;

public class MSVExpressionInformation {
    private static final Logger LOG = Logger.getLogger(MSVExpressionInformation.class.getName());
    private Map<Expression, List<List<Expression>>> mContainedInPaths;
    private boolean mCanHaveText = false;
    private Set<Expression> mSingletonChildren = new HashSet<Expression>();
    private Set<Expression> mMultipleChildren = new HashSet<Expression>();

    public MSVExpressionInformation(Expression exp, String schemaFileName) {
        this.mContainedInPaths = new HashMap<Expression, List<List<Expression>>>();
        ArrayList<List<Expression>> paths = new ArrayList<List<Expression>>();
        ArrayList<Expression> start = new ArrayList<Expression>(1);
        start.add(exp);
        paths.add(start);
        MSVExpressionInformation.buildPaths(paths);
        if (exp instanceof ElementExp && schemaFileName != null) {
            String string = PuzzlePiece.getName((NameClassAndExpression)exp);
        }
        for (List list : paths) {
            if ((MSVExpressionType)((Object)((Expression)list.get(list.size() - 1)).visit((ExpressionVisitor)PuzzlePiece.TYPE_VISITOR)) != MSVExpressionType.STRING) continue;
            this.mCanHaveText = true;
            break;
        }
        if (SchemaToTemplate.DEBUG.booleanValue()) {
            System.out.println("\n************ NEW EXPRESSION ****************");
            List<String> pathPrints = PathPrinter.printChildPaths(paths);
            if (paths == null) {
                System.out.println("No Path found.");
            } else {
                for (String string : pathPrints) {
                    System.out.println(string);
                }
            }
        }
        List<List<Expression>> pathsToChildren = MSVExpressionInformation.getPathsToClass(paths, NameClassAndExpression.class);
        for (List<Expression> list : pathsToChildren) {
            for (Expression step : list) {
                List<List<Expression>> pathsToStep = this.mContainedInPaths.get(step);
                if (pathsToStep == null) {
                    pathsToStep = new ArrayList<List<Expression>>(1);
                    pathsToStep.add(list);
                    this.mContainedInPaths.put(step, pathsToStep);
                    continue;
                }
                if (pathsToStep.contains(list)) continue;
                pathsToStep.add(list);
            }
        }
        this.registerChildrenMaxCardinalities(MSVExpressionInformation.getPathsToClass(paths, ElementExp.class));
    }

    private void registerChildrenMaxCardinalities(List<List<Expression>> waysToChildren) {
        HashMap<Expression, Boolean> multiples = new HashMap<Expression, Boolean>();
        HashMap<Expression, List<Expression>> paths = new HashMap<Expression, List<Expression>>();
        for (List<Expression> way : waysToChildren) {
            Expression childexp = way.get(way.size() - 1);
            Boolean newCardinality = Boolean.FALSE;
            for (Expression step : way) {
                if (!(step instanceof OneOrMoreExp)) continue;
                newCardinality = Boolean.TRUE;
                break;
            }
            if (multiples.containsKey(childexp)) {
                Boolean existingCardinality = (Boolean)multiples.get(childexp);
                boolean commonChoice = false;
                HashSet<ChoiceExp> choices = new HashSet<ChoiceExp>();
                for (Expression oldStep : (List)paths.get(childexp)) {
                    if (oldStep instanceof ChoiceExp) {
                        choices.add((ChoiceExp)oldStep);
                    }
                    if (!(oldStep instanceof OneOrMoreExp)) continue;
                    break;
                }
                for (Expression step : way) {
                    if (step instanceof ChoiceExp && choices.contains((ChoiceExp)step)) {
                        commonChoice = true;
                        break;
                    }
                    if (!(step instanceof OneOrMoreExp)) continue;
                    break;
                }
                if (!existingCardinality.booleanValue() || newCardinality.booleanValue()) {
                    // empty if block
                }
                if (!existingCardinality.equals(newCardinality)) {
                    if (commonChoice) {
                        System.err.println("We have a CHOICE between one definition with N and one with 1 -> What does that mean? WE CANNOT HANDLE THIS)");
                        try {
                            throw new Exception("We have a CHOICE between one definition with N and one with 1");
                        }
                        catch (Exception e) {
                            LOG.log(Level.SEVERE, null, e);
                        }
                    } else {
                        multiples.put(childexp, Boolean.TRUE);
                    }
                }
                if (!(existingCardinality.booleanValue() || newCardinality.booleanValue() || commonChoice)) {
                    System.err.println("Already defined as 1, but two times without common choice. What does that mean? WE CANNOT HANDLE THIS!!!");
                    try {
                        throw new Exception("Cardinality defined as 1 but with two choices");
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, null, e);
                    }
                }
            } else {
                multiples.put(childexp, newCardinality);
                paths.put(childexp, way);
            }
            this.setParentChildSingleton(childexp, newCardinality == false);
        }
    }

    private void setParentChildSingleton(Expression child, boolean singleton) {
        if (singleton) {
            this.mSingletonChildren.add(child);
        } else {
            this.mMultipleChildren.add(child);
        }
    }

    public Set<Expression> getSingletons() {
        return this.mSingletonChildren;
    }

    public Set<Expression> getMultiples() {
        return this.mMultipleChildren;
    }

    private static void buildPaths(List<List<Expression>> paths) {
        List<Expression> waytoresearch = paths.get(paths.size() - 1);
        Expression endpoint = waytoresearch.get(waytoresearch.size() - 1);
        List children = (List)endpoint.visit((ExpressionVisitor)PuzzlePiece.CHILD_VISITOR);
        if (children.size() == 1) {
            Expression child = (Expression)children.get(0);
            waytoresearch.add(child);
            if (!(child instanceof ElementExp) && !(child instanceof AttributeExp)) {
                MSVExpressionInformation.buildPaths(paths);
            }
        } else if (children.size() > 1) {
            paths.remove(paths.size() - 1);
            for (Expression child : children) {
                ArrayList<Expression> newway = new ArrayList<Expression>();
                newway.addAll(waytoresearch);
                newway.add(child);
                paths.add(newway);
                if (child instanceof ElementExp || child instanceof AttributeExp) continue;
                MSVExpressionInformation.buildPaths(paths);
            }
        }
    }

    private static List<List<Expression>> getPathsToClass(List<List<Expression>> paths, Class<?> clazz) {
        ArrayList<List<Expression>> remainingPaths = new ArrayList<List<Expression>>();
        for (List<Expression> path : paths) {
            if (!clazz.isInstance(path.get(path.size() - 1))) continue;
            remainingPaths.add(path);
        }
        return remainingPaths;
    }

    public List<List<Expression>> getPathsContaining(Expression exp) {
        return this.mContainedInPaths.get(exp);
    }

    public boolean canHaveText() {
        return this.mCanHaveText;
    }

    public boolean isMandatory(Collection<Expression> equallyNamedChildren) {
        if (equallyNamedChildren == null || equallyNamedChildren.size() == 0) {
            throw new RuntimeException("ExpressionInformation: Cannot determine isMandatory for a null or empty children list.");
        }
        HashSet<List<Expression>> twins = new HashSet<List<Expression>>();
        for (Expression exp : equallyNamedChildren) {
            if (!(exp instanceof NameClassAndExpression)) {
                throw new RuntimeException("ExpressionInformation: Cannot determine isMandatory for Expression other than ELEMENT and ATTRIBUTE");
            }
            twins.addAll(this.getPathsContaining(exp));
        }
        HashSet<Expression> visitedChoices = new HashSet<Expression>();
        for (List list : twins) {
            for (int s = 0; s < list.size(); ++s) {
                List otherPath;
                Expression step = (Expression)list.get(s);
                if (!(step instanceof ChoiceExp) || visitedChoices.contains(step)) continue;
                visitedChoices.add(step);
                ArrayList choiceInPaths = new ArrayList(this.mContainedInPaths.get(step));
                choiceInPaths.retainAll(twins);
                if (choiceInPaths.size() <= 1) {
                    return false;
                }
                int sharingPaths = 0;
                Iterator iterator = choiceInPaths.iterator();
                while (iterator.hasNext() && ((otherPath = (List)iterator.next()).size() <= s || !list.subList(0, s + 1).equals(otherPath.subList(0, s + 1)) || ++sharingPaths != 2)) {
                }
                if (sharingPaths >= 2) continue;
                return false;
            }
        }
        return true;
    }
}

