/*
 * Decompiled with CFR 0.152.
 */
package schema2template.grammar;

import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionVisitor;
import com.sun.msv.grammar.NameClassAndExpression;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.SequenceExp;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.IoCore;
import org.apache.tinkerpop.gremlin.structure.io.graphml.GraphMLIo;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import schema2template.grammar.PuzzlePiece;

class TinkerPopGraph {
    private final Expression exp;
    private final String schemaFileName;
    private final Graph graph;

    public TinkerPopGraph(Expression exp, String schemaFileName) {
        this.exp = exp;
        this.schemaFileName = schemaFileName;
        this.graph = TinkerPopGraph.buildGraph(exp);
    }

    public void exportAsGraphML(String targetDirectoryName) {
        if (this.exp instanceof ElementExp && this.schemaFileName != null) {
            String elementName = PuzzlePiece.getName((NameClassAndExpression)this.exp);
            String fileName = elementName.equals("*") ? "ALL_ELEMENTS" : elementName.replace(" | ", "_").replace(":", "_");
            try {
                File targetDir = new File(targetDirectoryName);
                targetDir.mkdirs();
                ((GraphMLIo)this.graph.io(IoCore.graphml())).writeGraph(targetDirectoryName + File.separator + fileName + ".graphml");
            }
            catch (IOException ex) {
                Logger.getLogger(TinkerPopGraph.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static Graph buildGraph(Expression exp) {
        return TinkerPopGraph.buildGraph(null, null, null, exp, null);
    }

    private static Graph buildGraph(Graph g, Vertex v, Vertex parentV, Expression exp, Expression parentExp) {
        if (g == null) {
            g = TinkerGraph.open();
            v = TinkerPopGraph.createVertex(g, exp);
        }
        TinkerPopGraph.addGraphProperties(g, v, parentV, exp, parentExp);
        if (!(exp instanceof NameClassAndExpression) || parentExp == null) {
            List children = (List)exp.visit((ExpressionVisitor)PuzzlePiece.CHILD_VISITOR);
            Integer newChildNo = 0;
            for (Expression newChildExp : children) {
                Vertex newChildV = TinkerPopGraph.createVertex(g, newChildExp);
                if (exp instanceof SequenceExp && parentV != null) {
                    Integer n = newChildNo;
                    Integer n2 = newChildNo = Integer.valueOf(newChildNo + 1);
                    v.addEdge("has", newChildV, new Object[]{"order", newChildNo.toString(), "color", "#00ee00"});
                }
                g = TinkerPopGraph.buildGraph(g, newChildV, v, newChildExp, exp);
            }
        }
        return g;
    }

    private static Vertex createVertex(Graph g, Expression exp) {
        Vertex v = null;
        String type = PuzzlePiece.getType(exp).toString();
        if (type != null && !type.isEmpty()) {
            v = g.addVertex(type);
        }
        return v;
    }

    private static Vertex addGraphProperties(Graph g, Vertex v, Vertex parentVertex, Expression exp, Expression parentExp) {
        if (v == null) {
            v = TinkerPopGraph.createVertex(g, exp);
        }
        String type = PuzzlePiece.getType(exp).toString();
        if (exp instanceof NameClassAndExpression) {
            String name = PuzzlePiece.getName((NameClassAndExpression)exp);
            v.property("label", (Object)name);
            if (exp instanceof ElementExp) {
                v.property("color", (Object)"#6495ed");
            } else {
                v.property("color", (Object)"#ee0000");
            }
        } else if (exp instanceof ReferenceExp) {
            String refName = ((ReferenceExp)exp).name;
            if (refName == null) {
                refName = "NONAME";
            }
            v.property("label", (Object)refName);
            v.property("color", (Object)"#ffd700");
        } else {
            v.property("label", (Object)type);
            v.property("type", (Object)type);
        }
        if (parentVertex != null && !(parentExp instanceof SequenceExp)) {
            parentVertex.addEdge("has", v, new Object[0]);
        }
        return v;
    }
}

