/*
 * Decompiled with CFR 0.152.
 */
package schema2template.grammar;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import schema2template.grammar.OdfFamilyPropertiesPatternMatcher;
import schema2template.grammar.PuzzleComponent;
import schema2template.grammar.PuzzlePiece;
import schema2template.grammar.XMLModel;
import schema2template.template.SourceCodeBaseClass;

public class OdfModel {
    private final Map<String, List<String>> mNameToFamiliesMap;
    private final Map<String, String> mComponentRootElementNames;
    private final Set<String> mRepetitionAttributeNames;
    private final Map<String, Map<String, String>> mAttributeDefaults;
    private final Map<String, List<String>> mStyleFamilyToPropertiesMap;
    private final String ALL_ELEMENTS = "*";
    private final XMLModel mXmlModel;

    public OdfModel(Map<String, List<String>> nameToFamiliesMap, Map<String, String> componentRootElementNames, Set<String> repetitionAttributeNames, Map<String, Map<String, String>> attributeDefaults, XMLModel xmlModel) {
        this.mNameToFamiliesMap = nameToFamiliesMap;
        this.mComponentRootElementNames = componentRootElementNames;
        this.mRepetitionAttributeNames = repetitionAttributeNames;
        this.mAttributeDefaults = attributeDefaults;
        this.mXmlModel = xmlModel;
        this.mStyleFamilyToPropertiesMap = new OdfFamilyPropertiesPatternMatcher(xmlModel.getGrammar()).getFamilyProperties();
    }

    public boolean isStylable(PuzzleComponent element) {
        return this.mNameToFamiliesMap.containsKey(element.getQName());
    }

    public boolean isStylable(SourceCodeBaseClass base) {
        boolean notStylable = false;
        boolean stylable = false;
        for (PuzzlePiece def : base.getChildElementsOfBaseClass()) {
            if (this.isStylable(def)) {
                stylable = true;
                continue;
            }
            notStylable = true;
        }
        if (stylable && !notStylable) {
            return true;
        }
        if (notStylable && !stylable) {
            return false;
        }
        throw new RuntimeException("Base Class " + base.getQName() + " used for stylable AND not stylable elements. This is not possible.");
    }

    public List<String> getStyleFamilies(PuzzleComponent element) {
        ArrayList<String> retval = new ArrayList<String>();
        if (this.mNameToFamiliesMap.containsKey(element.getQName())) {
            for (String family : this.mNameToFamiliesMap.get(element.getQName())) {
                retval.add(family);
            }
        }
        return retval;
    }

    public SortedSet<String> getStyleFamilies() {
        Iterator<List<String>> iter = this.mNameToFamiliesMap.values().iterator();
        ArrayList<String> families = new ArrayList<String>();
        while (iter.hasNext()) {
            for (String family : iter.next()) {
                families.add(family);
            }
        }
        return new TreeSet<String>(families);
    }

    public String getDefaultAttributeValue(String attributeName, String parentElementName) {
        String defaultValue = null;
        if (parentElementName.equals("table:table-cell") && attributeName.equals("table:protect")) {
            System.err.println("YEAH!");
        }
        if (this.mAttributeDefaults == null || attributeName == null || attributeName.isBlank()) {
            return null;
        }
        Map<String, String> defaultValueByElementParents = this.mAttributeDefaults.get(attributeName);
        if (defaultValueByElementParents == null) {
            return null;
        }
        defaultValue = defaultValueByElementParents.get(parentElementName);
        if (defaultValue == null) {
            defaultValue = defaultValueByElementParents.get("*");
        }
        return defaultValue;
    }

    public Set<String> getDefaultAttributeValues(String attributeName) {
        if (this.mAttributeDefaults == null || attributeName == null || attributeName.isBlank()) {
            return null;
        }
        Map<String, String> defaultValueByElementParents = this.mAttributeDefaults.get(attributeName);
        if (defaultValueByElementParents == null) {
            return null;
        }
        return new TreeSet<String>(defaultValueByElementParents.values());
    }

    public Map<String, List<String>> getStyleFamilyPropertiesMap() {
        return this.mStyleFamilyToPropertiesMap;
    }

    public boolean isRootOfComponent(String qualifiedElementName) {
        return this.mComponentRootElementNames.containsKey(qualifiedElementName);
    }

    public boolean isRepetionAttribute(String qualifiedAttributeName) {
        return this.mRepetitionAttributeNames.contains(qualifiedAttributeName);
    }

    public PuzzlePiece getRepetionAttribute(String qualifiedElementName) {
        PuzzlePiece repetitionAttributeName = null;
        for (PuzzlePiece attribute : this.mXmlModel.getElement(qualifiedElementName).getAttributes()) {
            if (!this.mRepetitionAttributeNames.contains(attribute.getQName())) continue;
            if (repetitionAttributeName != null) {
                throw new RuntimeException("In element '" + qualifiedElementName + "' should be only one repetition attribute, but there are '" + repetitionAttributeName + "' and '" + attribute.getQName() + "'!");
            }
            repetitionAttributeName = attribute;
        }
        return repetitionAttributeName;
    }
}

