/*
 * Decompiled with CFR 0.152.
 */
package schema2template.grammar;

import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionVisitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;
import schema2template.grammar.MSVExpressionVisitorChildren;

public final class MSVExpressionIterator
implements Iterator<Expression> {
    private static final Logger LOG = Logger.getLogger(MSVExpressionIterator.class.getName());
    private Expression mCurrentExpression;
    private MSVExpressionVisitorChildren mVisitor;
    private Stack<UniqueAncestor> mAncestorsAndCurrent;
    private HashSet<Expression> mKnownElementExpressions;
    private Class mDesiredExpression;
    private boolean mOnlyChildren;
    private int mCurrentDepth = 0;
    public static final boolean ALL_SUBTREE = true;
    public static final boolean DIRECT_CHILDREN_ONLY = true;

    public int getDepth() {
        return this.mCurrentDepth;
    }

    public MSVExpressionIterator(Expression root) {
        this(root, Expression.class, false);
    }

    public MSVExpressionIterator(Expression root, Class desiredExpression) {
        this(root, desiredExpression, false);
    }

    public MSVExpressionIterator(Expression root, Class desiredExpression, boolean onlyChildren) {
        this.mCurrentExpression = root;
        this.mDesiredExpression = desiredExpression;
        this.mOnlyChildren = onlyChildren;
        this.mVisitor = new MSVExpressionVisitorChildren();
        this.mKnownElementExpressions = new HashSet();
        this.mAncestorsAndCurrent = new Stack();
        this.mAncestorsAndCurrent.push(new UniqueAncestor(root, 0));
        while (!this.mDesiredExpression.isInstance(this.mCurrentExpression) && this.mCurrentExpression != null) {
            this.mCurrentExpression = this.getNextExpression();
        }
        if (this.mOnlyChildren && root == this.mCurrentExpression) {
            this.mCurrentExpression = this.getNextExpression();
        }
    }

    @Override
    public boolean hasNext() {
        return this.mCurrentExpression != null;
    }

    private Expression getNextExpression() {
        Expression nextExpression = null;
        if (this.mCurrentExpression != null) {
            List children;
            if (!(this.mOnlyChildren && this.mAncestorsAndCurrent.size() != 1 && this.mAncestorsAndCurrent.peek().mExp instanceof ElementExp || (children = (List)this.mCurrentExpression.visit((ExpressionVisitor)this.mVisitor)).size() <= 0)) {
                Expression nextExpCandidate = (Expression)children.get(0);
                this.mAncestorsAndCurrent.push(new UniqueAncestor(nextExpCandidate, 0));
                if (this.isNoKnownElement(nextExpCandidate)) {
                    nextExpression = nextExpCandidate;
                }
            }
            while (nextExpression == null && this.mAncestorsAndCurrent.size() > 1) {
                UniqueAncestor uniqueAncestor = this.mAncestorsAndCurrent.pop();
                int nextSiblingIndex = uniqueAncestor.mSiblingIndex + 1;
                Expression parent = this.mAncestorsAndCurrent.peek().mExp;
                List siblings = (List)parent.visit((ExpressionVisitor)this.mVisitor);
                if (nextSiblingIndex >= siblings.size()) continue;
                Expression nextExpCandidate = (Expression)siblings.get(nextSiblingIndex);
                this.mAncestorsAndCurrent.push(new UniqueAncestor(nextExpCandidate, nextSiblingIndex));
                if (!this.isNoKnownElement(nextExpCandidate)) continue;
                nextExpression = nextExpCandidate;
            }
        }
        return nextExpression;
    }

    private boolean isNoKnownElement(Expression exp) {
        boolean isNew = false;
        if (!(exp instanceof ElementExp) || !this.mKnownElementExpressions.contains(exp)) {
            this.mKnownElementExpressions.add(exp);
            isNew = true;
        }
        return isNew;
    }

    @Override
    public Expression next() {
        if (this.mCurrentExpression == null) {
            return null;
        }
        Expression retVal = this.mCurrentExpression;
        this.mCurrentDepth = this.mAncestorsAndCurrent.size() - 1;
        this.mCurrentExpression = this.getNextExpression();
        while (!this.mDesiredExpression.isInstance(this.mCurrentExpression) && this.mCurrentExpression != null) {
            this.mCurrentExpression = this.getNextExpression();
        }
        return retVal;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported.");
    }

    private class UniqueAncestor {
        private Expression mExp;
        private int mSiblingIndex;

        public UniqueAncestor(Expression exp, int siblingIndex) {
            this.mExp = exp;
            this.mSiblingIndex = siblingIndex;
        }
    }
}

