/*
 * Decompiled with CFR 0.152.
 */
package schema2template.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import schema2template.model.MSVExpressionType;
import schema2template.model.PuzzleComponent;
import schema2template.model.PuzzlePiece;
import schema2template.model.QNamed;
import schema2template.model.QNamedPuzzleComponent;
import schema2template.model.XMLModel;

public class PuzzlePieceSet
implements QNamedPuzzleComponent,
Collection<PuzzlePiece> {
    private boolean mImmutable = false;
    private SortedSet<PuzzlePiece> mDefinitions;

    public PuzzlePieceSet() {
        this.mDefinitions = new TreeSet<PuzzlePiece>();
    }

    public PuzzlePieceSet(Collection<PuzzlePiece> c) {
        this.mDefinitions = new TreeSet<PuzzlePiece>(c);
    }

    private void assertNotImmutable() {
        if (this.mImmutable) {
            throw new RuntimeException("Attempt to change an immutable DefinitionSet.");
        }
    }

    private void assertNotEmpty(String plannedAction) {
        if (this.size() == 0) {
            throw new RuntimeException("Attempt to " + plannedAction + " of empty DefinitionSet ");
        }
    }

    private void assertMultiples(String plannedAction) {
        this.assertNotEmpty(plannedAction);
        PuzzlePiece first = this.first();
        MSVExpressionType type = first.getType();
        String name = first.getQName();
        for (PuzzlePiece def : this) {
            if (!type.equals((Object)def.getType())) {
                throw new RuntimeException("Attempt to " + plannedAction + " of DefinitionSet consisting of different types of Definition objetcs.");
            }
            String defname = def.getQName();
            if ((name != null || defname == null) && name.equals(defname)) continue;
            throw new RuntimeException("Attempt to " + plannedAction + " of DefinitionSet consisting of differently named Definition objetcs.");
        }
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof PuzzlePieceSet && ((PuzzlePieceSet)o).mDefinitions.equals(this.mDefinitions);
    }

    @Override
    public int hashCode() {
        return this.mDefinitions.hashCode();
    }

    private PuzzlePiece first() {
        return this.iterator().next();
    }

    Map<PuzzlePiece, PuzzlePiece> uniteDefinitionsWithEqualContent() {
        HashMap<PuzzlePiece, PuzzlePiece> retval = new HashMap<PuzzlePiece, PuzzlePiece>();
        TreeSet<PuzzlePiece> immutableSet = new TreeSet<PuzzlePiece>(this.mDefinitions);
        block0: for (PuzzlePiece def1 : immutableSet) {
            if (!this.mDefinitions.contains(def1)) continue;
            for (PuzzlePiece def2 : immutableSet.tailSet(def1)) {
                if (def1 == def2 || !this.mDefinitions.contains(def2)) continue;
                if (!def1.getQName().equals(def2.getQName())) continue block0;
                if (!def1.contentEquals(def2)) continue;
                this.remove(def2);
                retval.put(def2, def1);
                def1.getParents().addAll(def2.getParents());
            }
        }
        for (PuzzlePiece def : this.mDefinitions) {
            PuzzlePieceSet immutableDups = new PuzzlePieceSet(def.withMultiples());
            for (PuzzlePiece multiple : immutableDups) {
                if (multiple == def || this.mDefinitions.contains(multiple)) continue;
                def.withMultiples().remove(multiple);
            }
        }
        return retval;
    }

    public void makeImmutable() {
        this.mImmutable = true;
    }

    public PuzzlePieceSet withoutMultiples() {
        HashMap<String, PuzzlePiece> uniqueMap = new HashMap<String, PuzzlePiece>();
        for (PuzzlePiece def : this) {
            uniqueMap.put(def.getQName(), def);
        }
        return new PuzzlePieceSet(uniqueMap.values());
    }

    public PuzzlePieceSet without(QNamedPuzzleComponent removeAll) {
        PuzzlePieceSet retval = new PuzzlePieceSet(this);
        retval.removeAll(removeAll.getCollection());
        return retval;
    }

    public PuzzlePieceSet byParent(QNamedPuzzleComponent parents) {
        PuzzlePieceSet retval = new PuzzlePieceSet();
        block0: for (PuzzlePiece def : this) {
            PuzzlePieceSet defparents = def.getParents();
            for (PuzzlePiece parent : parents.getCollection()) {
                if (!defparents.contains(parent)) continue;
                retval.add(def);
                continue block0;
            }
        }
        return retval;
    }

    public boolean containsName(String aDefinitionName) {
        for (PuzzlePiece def : this) {
            if (!def.getQName().equals(aDefinitionName)) continue;
            return true;
        }
        return false;
    }

    public boolean containsName(QNamed aNamed) {
        return this.containsName(aNamed.getQName());
    }

    @Override
    public String getQName() {
        this.assertMultiples("get name");
        return this.first().getQName();
    }

    @Override
    public MSVExpressionType getType() {
        this.assertMultiples("get type");
        return this.first().getType();
    }

    @Override
    public boolean canHaveText() {
        this.assertMultiples("determine text availability");
        for (PuzzlePiece def : this) {
            if (!def.canHaveText()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSingleton(PuzzleComponent child) {
        for (PuzzlePiece def : this) {
            if (def.isSingleton(child)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getLocalName() {
        return XMLModel.extractLocalname(this.getQName());
    }

    @Override
    public String getNamespace() {
        return XMLModel.extractNamespace(this.getQName());
    }

    public String toString() {
        return this.getQName();
    }

    @Override
    public boolean add(PuzzlePiece e) {
        this.assertNotImmutable();
        return this.mDefinitions.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends PuzzlePiece> c) {
        this.assertNotImmutable();
        return this.mDefinitions.addAll(c);
    }

    @Override
    public void clear() {
        this.assertNotImmutable();
        this.mDefinitions.clear();
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof PuzzlePiece ? this.mDefinitions.contains((PuzzlePiece)o) : false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.mDefinitions.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.mDefinitions.isEmpty();
    }

    @Override
    public Iterator<PuzzlePiece> iterator() {
        return this.mDefinitions.iterator();
    }

    @Override
    public boolean remove(Object o) {
        this.assertNotImmutable();
        return o instanceof PuzzlePiece ? this.mDefinitions.remove((PuzzlePiece)o) : false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.assertNotImmutable();
        return this.mDefinitions.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.assertNotImmutable();
        return this.mDefinitions.retainAll(c);
    }

    @Override
    public int size() {
        return this.mDefinitions.size();
    }

    @Override
    public Object[] toArray() {
        return this.mDefinitions.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.mDefinitions.toArray(a);
    }

    @Override
    public PuzzlePieceSet getChildElements() {
        PuzzlePieceSet retval = new PuzzlePieceSet();
        for (PuzzlePiece def : this) {
            retval.addAll(def.getChildElements());
        }
        return retval;
    }

    @Override
    public boolean isMandatory(QNamedPuzzleComponent child) {
        for (PuzzlePiece def : this) {
            if (!def.isMandatory(child)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<PuzzlePiece> getCollection() {
        return this.mDefinitions;
    }

    @Override
    public PuzzlePieceSet getAttributes() {
        PuzzlePieceSet retval = new PuzzlePieceSet();
        for (PuzzlePiece def : this) {
            retval.addAll(def.getAttributes());
        }
        return retval;
    }

    @Override
    public PuzzlePieceSet getDatatypes() {
        PuzzlePieceSet retval = new PuzzlePieceSet();
        for (PuzzlePiece def : this) {
            retval.addAll(def.getDatatypes());
        }
        return retval;
    }

    @Override
    public PuzzlePieceSet getParents() {
        PuzzlePieceSet retval = new PuzzlePieceSet();
        for (PuzzlePiece def : this) {
            retval.addAll(def.getParents());
        }
        return retval;
    }

    @Override
    public PuzzlePieceSet getValues() {
        PuzzlePieceSet retval = new PuzzlePieceSet();
        for (PuzzlePiece def : this) {
            retval.addAll(def.getValues());
        }
        return retval;
    }
}

