/*
 * Decompiled with CFR 0.152.
 */
package schema2template.model;

import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.DataExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionVisitor;
import com.sun.msv.grammar.NameClassAndExpression;
import com.sun.msv.grammar.NameClassVisitor;
import com.sun.msv.grammar.ValueExp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import schema2template.model.GraphSupport;
import schema2template.model.MSVExpressionInformation;
import schema2template.model.MSVExpressionIterator;
import schema2template.model.MSVExpressionType;
import schema2template.model.MSVExpressionVisitorChildren;
import schema2template.model.MSVExpressionVisitorType;
import schema2template.model.MSVNameClassVisitorList;
import schema2template.model.PuzzleComponent;
import schema2template.model.PuzzlePieceSet;
import schema2template.model.QNamedPuzzleComponent;
import schema2template.model.XMLModel;

public class PuzzlePiece
implements Comparable<PuzzlePiece>,
QNamedPuzzleComponent {
    static final MSVExpressionVisitorType TYPE_VISITOR = new MSVExpressionVisitorType();
    static final MSVNameClassVisitorList NAME_VISITOR = new MSVNameClassVisitorList();
    static final MSVExpressionVisitorChildren CHILD_VISITOR = new MSVExpressionVisitorChildren();
    private Expression mExpression;
    private PuzzlePieceSet mMultiples = new PuzzlePieceSet();
    private PuzzlePieceSet mParents = new PuzzlePieceSet();
    private String mName;
    private PuzzlePieceSet mChildElements = new PuzzlePieceSet();
    private HashSet<String> mMandatoryChildElementNames = new HashSet();
    private PuzzlePieceSet mAttributes = new PuzzlePieceSet();
    private HashSet<String> mMandatoryChildAttributeNames = new HashSet();
    private boolean mCanHaveText = false;
    private Set<Expression> mSingletonChildExpressions;
    private Set<Expression> mMultipleChildExpressions;
    private PuzzlePieceSet mValues = new PuzzlePieceSet();
    private PuzzlePieceSet mDatatypes = new PuzzlePieceSet();

    private PuzzlePiece(Expression exp, String name) {
        this.mExpression = exp;
        this.mName = name;
    }

    private PuzzlePiece(Expression exp) {
        this.mExpression = exp;
        MSVExpressionType type = (MSVExpressionType)((Object)exp.visit((ExpressionVisitor)TYPE_VISITOR));
        if (type == MSVExpressionType.ATTRIBUTE || type == MSVExpressionType.ELEMENT) {
            this.mName = PuzzlePiece.getName((NameClassAndExpression)exp);
        }
        if (type == MSVExpressionType.VALUE) {
            this.mName = ((ValueExp)exp).value.toString();
        }
        if (type == MSVExpressionType.DATA) {
            this.mName = ((DataExp)exp).getName().localName;
        }
    }

    static String getName(NameClassAndExpression exp) {
        Object name = null;
        List names = (List)exp.getNameClass().visit((NameClassVisitor)NAME_VISITOR);
        if (names == null) {
            name = "null";
        } else if (names.size() != 1) {
            name = "";
            for (String n : names) {
                name = (String)name + " | " + n;
            }
        } else {
            name = (String)names.get(0);
        }
        return name;
    }

    public boolean equals(Object b) {
        if (b instanceof PuzzlePiece) {
            PuzzlePiece d = (PuzzlePiece)b;
            if (d.mName.equals(this.mName) && d.mExpression.equals((Object)this.mExpression)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 1013 * this.mName.hashCode() ^ 1009 * this.mExpression.hashCode();
    }

    @Override
    public int compareTo(PuzzlePiece o) {
        int retval = this.mName.compareTo(o.mName);
        if (retval != 0) {
            return retval;
        }
        return Integer.compare(this.hashCode(), o.hashCode());
    }

    protected boolean contentEquals(PuzzlePiece other) {
        if (!this.mName.equals(other.mName)) {
            return false;
        }
        if (!this.getType().equals((Object)other.getType())) {
            return false;
        }
        if (this.mCanHaveText != other.mCanHaveText) {
            return false;
        }
        if (!this.mChildElements.equals(other.mChildElements)) {
            return false;
        }
        if (!this.mAttributes.equals(other.mAttributes)) {
            return false;
        }
        if (!this.mMandatoryChildElementNames.equals(other.mMandatoryChildElementNames)) {
            return false;
        }
        if (!this.mMandatoryChildAttributeNames.equals(other.mMandatoryChildAttributeNames)) {
            return false;
        }
        if (!this.mValues.equals(other.mValues)) {
            return false;
        }
        return this.mDatatypes.equals(other.mDatatypes);
    }

    @Override
    public String getQName() {
        return this.mName;
    }

    @Override
    public String getLocalName() {
        return XMLModel.extractLocalname(this.mName);
    }

    @Override
    public String getNamespace() {
        return XMLModel.extractNamespace(this.mName);
    }

    public String toString() {
        return this.getQName();
    }

    @Override
    public MSVExpressionType getType() {
        return (MSVExpressionType)((Object)this.mExpression.visit((ExpressionVisitor)TYPE_VISITOR));
    }

    static MSVExpressionType getType(Expression exp) {
        return (MSVExpressionType)((Object)exp.visit((ExpressionVisitor)TYPE_VISITOR));
    }

    public Expression getExpression() {
        return this.mExpression;
    }

    @Override
    public boolean canHaveText() {
        return this.mCanHaveText;
    }

    @Override
    public boolean isSingleton(PuzzleComponent child) {
        for (PuzzlePiece element : child.getCollection()) {
            if (this.mMultipleChildExpressions.contains(element.getExpression())) {
                return false;
            }
            if (this.mSingletonChildExpressions.contains(element.getExpression())) continue;
            throw new RuntimeException("Definition.isSingleton: Unknown child element.");
        }
        return true;
    }

    @Override
    public Collection<PuzzlePiece> getCollection() {
        return Collections.singletonList(this);
    }

    public PuzzlePieceSet withMultiples() {
        return this.mMultiples;
    }

    public int getMultipleNumber() {
        int retval = 0;
        Iterator<PuzzlePiece> iter = this.mMultiples.iterator();
        while (iter.hasNext()) {
            if (iter.next().equals(this)) {
                return retval;
            }
            ++retval;
        }
        return 0;
    }

    @Override
    public PuzzlePieceSet getParents() {
        return this.mParents;
    }

    @Override
    public PuzzlePieceSet getChildElements() {
        return this.mChildElements;
    }

    @Override
    public boolean isMandatory(QNamedPuzzleComponent child) {
        switch (child.getType()) {
            case ATTRIBUTE: {
                if (!this.mMandatoryChildAttributeNames.contains(child.getQName())) break;
                return true;
            }
            case ELEMENT: {
                if (!this.mMandatoryChildElementNames.contains(child.getQName())) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public PuzzlePieceSet getAttributes() {
        return this.mAttributes;
    }

    @Override
    public PuzzlePieceSet getValues() {
        return this.mValues;
    }

    @Override
    public PuzzlePieceSet getDatatypes() {
        return this.mDatatypes;
    }

    public static void extractPuzzlePieces(Expression root, PuzzlePieceSet newElementSet, PuzzlePieceSet newAttributeSet, String schemaFileName) {
        PuzzlePiece.extractTypedPuzzlePieces(root, newElementSet, ElementExp.class);
        PuzzlePiece.extractTypedPuzzlePieces(root, newAttributeSet, AttributeExp.class);
        PuzzlePiece.configureProperties(newElementSet, newAttributeSet, schemaFileName);
        PuzzlePiece.reduceDatatypes(newAttributeSet);
        PuzzlePiece.reduceValues(newAttributeSet);
        PuzzlePiece.reduceAttributes(newElementSet, newAttributeSet);
        PuzzlePiece.makePuzzlePiecesImmutable(newElementSet);
        PuzzlePiece.makePuzzlePiecesImmutable(newAttributeSet);
    }

    private static <T extends Expression> void extractTypedPuzzlePieces(Expression root, PuzzlePieceSet setToBeFilled, Class<T> superclass) {
        MSVExpressionIterator iter = new MSVExpressionIterator(root, superclass);
        HashMap<String, ArrayList<PuzzlePiece>> multipleMap = new HashMap<String, ArrayList<PuzzlePiece>>();
        while (iter.hasNext()) {
            Expression exp = iter.next();
            List names = (List)((NameClassAndExpression)exp).getNameClass().visit((NameClassVisitor)NAME_VISITOR);
            for (String name : names) {
                if (name.length() == 0) {
                    throw new RuntimeException("Unnamed ELEMENT or ATTRIBUTE expression.");
                }
                PuzzlePiece newDefinition = new PuzzlePiece(exp, name);
                setToBeFilled.add(newDefinition);
                ArrayList<PuzzlePiece> multiples = (ArrayList<PuzzlePiece>)multipleMap.get(name);
                if (multiples != null) {
                    multiples.add(newDefinition);
                    continue;
                }
                multiples = new ArrayList<PuzzlePiece>(1);
                multiples.add(newDefinition);
                multipleMap.put(name, multiples);
            }
        }
        for (PuzzlePiece def : setToBeFilled) {
            def.mMultiples = new PuzzlePieceSet((Collection)multipleMap.get(def.getQName()));
        }
    }

    private static Map<Expression, List<PuzzlePiece>> buildReverseMap(PuzzlePieceSet defs) {
        HashMap<Expression, List<PuzzlePiece>> retval = new HashMap<Expression, List<PuzzlePiece>>();
        for (PuzzlePiece def : defs) {
            ArrayList<PuzzlePiece> list = (ArrayList<PuzzlePiece>)retval.get(def.getExpression());
            if (list == null) {
                list = new ArrayList<PuzzlePiece>();
                retval.put(def.getExpression(), list);
            }
            list.add(def);
        }
        return retval;
    }

    private static Map<String, List<Expression>> buildNameExpressionsMap(PuzzlePieceSet defs) {
        HashMap<String, List<Expression>> retval = new HashMap<String, List<Expression>>();
        for (PuzzlePiece def : defs) {
            ArrayList<Expression> list = (ArrayList<Expression>)retval.get(def.getQName());
            if (list == null) {
                list = new ArrayList<Expression>();
                retval.put(def.getQName(), list);
            }
            list.add(def.getExpression());
        }
        return retval;
    }

    private static void reduceValues(PuzzlePieceSet attributes) {
        PuzzlePieceSet values = new PuzzlePieceSet();
        for (PuzzlePiece attr : attributes) {
            values.addAll(attr.getValues());
        }
        Map<PuzzlePiece, PuzzlePiece> lostToSurvived = values.uniteDefinitionsWithEqualContent();
        for (PuzzlePiece attr : attributes) {
            PuzzlePieceSet attributeValues = attr.getValues();
            PuzzlePieceSet immutable = new PuzzlePieceSet(attributeValues);
            for (PuzzlePiece value : immutable) {
                if (!lostToSurvived.containsKey(value)) continue;
                attributeValues.remove(value);
                attributeValues.add(lostToSurvived.get(value));
            }
        }
    }

    private static void reduceDatatypes(PuzzlePieceSet attributes) {
        PuzzlePieceSet datatypes = new PuzzlePieceSet();
        for (PuzzlePiece attr : attributes) {
            datatypes.addAll(attr.getDatatypes());
        }
        Map<PuzzlePiece, PuzzlePiece> lostToSurvived = datatypes.uniteDefinitionsWithEqualContent();
        for (PuzzlePiece attr : attributes) {
            PuzzlePieceSet attributeDatatypes = attr.getValues();
            PuzzlePieceSet immutable = new PuzzlePieceSet(attributeDatatypes);
            for (PuzzlePiece datatype : immutable) {
                if (!lostToSurvived.containsKey(datatype)) continue;
                attributeDatatypes.remove(datatype);
                attributeDatatypes.add(lostToSurvived.get(datatype));
            }
        }
    }

    private static void reduceAttributes(PuzzlePieceSet elements, PuzzlePieceSet attributes) {
        Map<PuzzlePiece, PuzzlePiece> lostToSurvived = attributes.uniteDefinitionsWithEqualContent();
        for (PuzzlePiece el : elements) {
            PuzzlePieceSet elementAttributes = el.getAttributes();
            PuzzlePieceSet immutable = new PuzzlePieceSet(elementAttributes);
            for (PuzzlePiece attribute : immutable) {
                if (!lostToSurvived.containsKey(attribute)) continue;
                elementAttributes.remove(attribute);
                elementAttributes.add(lostToSurvived.get(attribute));
            }
        }
    }

    private static void configureProperties(PuzzlePieceSet elements, PuzzlePieceSet attributes, String schemaFileName) {
        Map<Expression, List<PuzzlePiece>> reverseElementMap = PuzzlePiece.buildReverseMap(elements);
        Map<Expression, List<PuzzlePiece>> reverseAttributeMap = PuzzlePiece.buildReverseMap(attributes);
        for (PuzzlePiece def : elements) {
            MSVExpressionIterator childFinder = new MSVExpressionIterator(def.getExpression(), NameClassAndExpression.class, true);
            while (childFinder.hasNext()) {
                Expression child_exp = childFinder.next();
                List<PuzzlePiece> child_defs = null;
                PuzzlePieceSet whereToAdd = null;
                if (child_exp instanceof ElementExp) {
                    child_defs = reverseElementMap.get(child_exp);
                    whereToAdd = def.mChildElements;
                } else if (child_exp instanceof AttributeExp) {
                    child_defs = reverseAttributeMap.get(child_exp);
                    whereToAdd = def.mAttributes;
                }
                if (child_defs == null) continue;
                whereToAdd.addAll((Collection<? extends PuzzlePiece>)child_defs);
                for (PuzzlePiece child_def : child_defs) {
                    child_def.mParents.add(def);
                }
            }
            GraphSupport graphSupport = new GraphSupport(def.getExpression(), schemaFileName);
            MSVExpressionInformation elementInfo = new MSVExpressionInformation(def.getExpression(), schemaFileName);
            def.mCanHaveText = elementInfo.canHaveText();
            Map<String, List<Expression>> atnameToDefs = PuzzlePiece.buildNameExpressionsMap(def.mAttributes);
            for (String name : atnameToDefs.keySet()) {
                if (!elementInfo.isMandatory((Collection<Expression>)atnameToDefs.get(name))) continue;
                def.mMandatoryChildAttributeNames.add(name);
            }
            Map<String, List<Expression>> elnameToDefs = PuzzlePiece.buildNameExpressionsMap(def.mChildElements);
            for (String name : elnameToDefs.keySet()) {
                if (!elementInfo.isMandatory((Collection<Expression>)elnameToDefs.get(name))) continue;
                def.mMandatoryChildElementNames.add(name);
            }
            def.mSingletonChildExpressions = elementInfo.getSingletons();
            def.mMultipleChildExpressions = elementInfo.getMultiples();
        }
        for (PuzzlePiece def : attributes) {
            MSVExpressionIterator datatypeFinder = new MSVExpressionIterator(def.getExpression(), DataExp.class, true);
            while (datatypeFinder.hasNext()) {
                DataExp data_exp = (DataExp)datatypeFinder.next();
                def.mDatatypes.add(new PuzzlePiece((Expression)data_exp));
            }
            MSVExpressionIterator valueFinder = new MSVExpressionIterator(def.getExpression(), ValueExp.class, true);
            while (valueFinder.hasNext()) {
                ValueExp value_exp = (ValueExp)valueFinder.next();
                if (!value_exp.getName().localName.equals("token")) continue;
                def.mValues.add(new PuzzlePiece((Expression)value_exp));
            }
        }
    }

    private static void makePuzzlePiecesImmutable(PuzzlePieceSet defs) {
        for (PuzzlePiece def : defs) {
            def.mAttributes.makeImmutable();
            def.mChildElements.makeImmutable();
            def.mMultiples.makeImmutable();
            def.mParents.makeImmutable();
            def.mValues.makeImmutable();
            def.mDatatypes.makeImmutable();
        }
        defs.makeImmutable();
    }
}

