/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.text;

import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.text.TextCAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.w3c.dom.Node;

public class TextSElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "s");
    private static final Logger LOG = Logger.getLogger(TextSElement.class.getName());

    public TextSElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    @Override
    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public Integer getTextCAttribute() {
        TextCAttribute attr = (TextCAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "c");
        if (attr != null) {
            return attr.intValue();
        }
        return null;
    }

    public void setTextCAttribute(Integer textCValue) {
        TextCAttribute attr = new TextCAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setIntValue(textCValue);
    }

    @Override
    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }

    @Override
    public OdfElement split(int posStart) {
        TextSElement newElement = this;
        if (posStart > 0) {
            newElement = (TextSElement)((Object)this.cloneNode(true));
            int repeated = this.getTextCAttribute();
            if (repeated > 1) {
                if (posStart > 1) {
                    this.setTextCAttribute(posStart);
                } else {
                    this.removeAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "c");
                }
                if (repeated - posStart > 1) {
                    newElement.setTextCAttribute(repeated - posStart);
                } else {
                    newElement.removeAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "c");
                }
            }
            Node nextNodeSibling = this.getNextSibling();
            OdfElement parent = (OdfElement)((Object)this.getParentNode());
            if (nextNodeSibling == null) {
                parent.appendChild((Node)((Object)newElement));
            } else {
                parent.insertBefore((Node)((Object)newElement), nextNodeSibling);
            }
        } else {
            LOG.fine("The result from a split at the beginning is equal its input! Likely nested <text:spans> having template and hard style...");
        }
        return newElement;
    }

    @Override
    public int getRepetition() {
        Integer spaces = this.getTextCAttribute();
        if (spaces == null) {
            spaces = 1;
        }
        return spaces;
    }

    @Override
    public boolean isComponentRoot() {
        return true;
    }
}

