/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.regex.Pattern;
import org.odftoolkit.odfdom.type.OdfDataType;
import org.odftoolkit.odfdom.type.OdfFieldDataType;

public class Percent
implements OdfFieldDataType,
OdfDataType {
    private double mN;
    private static final Pattern percentPattern = Pattern.compile("^-?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)%$");

    public Percent(double n) throws IllegalArgumentException {
        this.mN = n;
    }

    public String toString() {
        return Double.toString(this.mN * 100.0) + "%";
    }

    public static Percent valueOf(String stringValue) throws IllegalArgumentException {
        if (stringValue == null || stringValue.length() == 0) {
            return new Percent(0.0);
        }
        int n = stringValue.indexOf("%");
        if (n != -1) {
            return new Percent(Double.parseDouble(stringValue.substring(0, n)) / 100.0);
        }
        throw new IllegalArgumentException("parameter is invalid for datatype Percent");
    }

    public double doubleValue() {
        return this.mN;
    }

    public static boolean isValid(Double doubleValue) {
        return doubleValue != null;
    }

    public static boolean isValid(String stringValue) {
        return stringValue != null && percentPattern.matcher(stringValue).matches();
    }
}

