/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.odftoolkit.odfdom.type.IDREF;
import org.odftoolkit.odfdom.type.OdfDataType;

public class IDREFS
implements OdfDataType {
    private String mIdRefs;

    public IDREFS(List<IDREF> idRefList) throws IllegalArgumentException {
        if (idRefList == null || idRefList.size() == 0) {
            throw new IllegalArgumentException("parameter can not be null for IDREFS");
        }
        this.mIdRefs = idRefList.stream().map(IDREF::toString).collect(Collectors.joining(" "));
    }

    public String toString() {
        return this.mIdRefs;
    }

    public static IDREFS valueOf(String stringValue) throws IllegalArgumentException {
        String[] names;
        if (stringValue == null || stringValue.length() == 0) {
            throw new IllegalArgumentException("parameter is invalid for datatype IDREFS");
        }
        ArrayList<IDREF> aRet = new ArrayList<IDREF>();
        for (String name : names = stringValue.split(" ")) {
            aRet.add(new IDREF(name));
        }
        return new IDREFS(aRet);
    }

    public List<IDREF> getIDREFList() {
        String[] names;
        ArrayList<IDREF> aRet = new ArrayList<IDREF>();
        for (String name : names = this.mIdRefs.split(" ")) {
            aRet.add(new IDREF(name));
        }
        return aRet;
    }

    public static boolean isValid(String stringValue) {
        String[] names;
        if (stringValue == null) {
            return false;
        }
        if (stringValue.length() == 0) {
            return false;
        }
        for (String name : names = stringValue.split(" ")) {
            if (IDREF.isValid(name)) continue;
            return false;
        }
        return true;
    }
}

