/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.odftoolkit.odfdom.type.CellRangeAddress;
import org.odftoolkit.odfdom.type.OdfDataType;

public class CellRangeAddressList
implements OdfDataType {
    private String mCellRangeAddressList;

    public CellRangeAddressList(List<CellRangeAddress> cellRangeAddressList) throws IllegalArgumentException {
        if (cellRangeAddressList == null) {
            throw new IllegalArgumentException("parameter can not be null for CellRangeAddressList");
        }
        this.mCellRangeAddressList = cellRangeAddressList.stream().map(CellRangeAddress::toString).collect(Collectors.joining(" "));
    }

    public String toString() {
        return this.mCellRangeAddressList;
    }

    public static CellRangeAddressList valueOf(String stringValue) throws IllegalArgumentException {
        String[] names;
        if (stringValue == null) {
            throw new IllegalArgumentException("parameter is invalid for datatype CellRangeAddressList");
        }
        ArrayList<CellRangeAddress> aRet = new ArrayList<CellRangeAddress>();
        for (String name : names = stringValue.split(" ")) {
            aRet.add(new CellRangeAddress(name));
        }
        return new CellRangeAddressList(aRet);
    }

    public List<CellRangeAddress> getCellRangesAddressList() {
        String[] names;
        ArrayList<CellRangeAddress> aRet = new ArrayList<CellRangeAddress>();
        for (String name : names = this.mCellRangeAddressList.split(" ")) {
            aRet.add(new CellRangeAddress(name));
        }
        return aRet;
    }

    public static boolean isValid(String stringValue) {
        String[] names;
        if (stringValue == null) {
            return false;
        }
        if (stringValue.length() == 0) {
            return true;
        }
        for (String name : names = stringValue.split(" ")) {
            if (CellRangeAddress.isValid(name)) continue;
            return false;
        }
        return true;
    }
}

