/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg.rdfa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.NamespaceContext;

final class EvalContext
implements NamespaceContext {
    EvalContext parent;
    String base;
    String parentSubject;
    String parentObject;
    String language;
    String vocab;
    List<String> forwardProperties;
    List<String> backwardProperties;
    Map<String, String> xmlnsMap = Collections.emptyMap();
    Map<String, String> prefixMap = Collections.emptyMap();

    protected EvalContext(String base) {
        this.base = base;
        this.parentSubject = base;
        this.forwardProperties = new ArrayList<String>();
        this.backwardProperties = new ArrayList<String>();
    }

    public EvalContext(EvalContext toCopy) {
        this.base = toCopy.base;
        this.parentSubject = toCopy.parentSubject;
        this.parentObject = toCopy.parentObject;
        this.language = toCopy.language;
        this.forwardProperties = new ArrayList<String>(toCopy.forwardProperties);
        this.backwardProperties = new ArrayList<String>(toCopy.backwardProperties);
        this.parent = toCopy;
        this.vocab = toCopy.vocab;
    }

    public void setBase(String abase) {
        boolean setPS = Objects.equals(this.parentSubject, this.base);
        boolean setPO = Objects.equals(this.parentObject, this.base);
        this.base = abase.contains("#") ? abase.substring(0, abase.indexOf("#")) : abase;
        if (setPS) {
            this.parentSubject = this.base;
        }
        if (setPO) {
            this.parentObject = this.base;
        }
        if (this.parent != null) {
            this.parent.setBase(this.base);
        }
    }

    public String toString() {
        return String.format("[\n\tBase: %s\n\tPS: %s\n\tPO: %s\n\tlang: %s\n\tIncomplete: -> %s <- %s\n]", this.base, this.parentSubject, this.parentObject, this.language, this.forwardProperties.size(), this.backwardProperties.size());
    }

    public void setPrefix(String prefix, String uri) {
        if (uri.length() == 0) {
            uri = this.base;
        }
        if (this.prefixMap == Collections.EMPTY_MAP) {
            this.prefixMap = new HashMap<String, String>();
        }
        this.prefixMap.put(prefix, uri);
    }

    public String getURIForPrefix(String prefix) {
        if (this.prefixMap.containsKey(prefix)) {
            return this.prefixMap.get(prefix);
        }
        if (this.xmlnsMap.containsKey(prefix)) {
            return this.xmlnsMap.get(prefix);
        }
        if (this.parent != null) {
            return this.parent.getURIForPrefix(prefix);
        }
        return null;
    }

    public void setNamespaceURI(String prefix, String uri) {
        if (uri.length() == 0) {
            uri = this.base;
        }
        if (this.xmlnsMap == Collections.EMPTY_MAP) {
            this.xmlnsMap = new HashMap<String, String>();
        }
        this.xmlnsMap.put(prefix, uri);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (this.xmlnsMap.containsKey(prefix)) {
            return this.xmlnsMap.get(prefix);
        }
        if (this.parent != null) {
            return this.parent.getNamespaceURI(prefix);
        }
        return null;
    }

    @Override
    public String getPrefix(String uri) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Iterator<String> getPrefixes(String uri) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setTerm(String term, String uri) {
        this.setPrefix(term + ":", uri);
    }

    public String getURIForTerm(String term) {
        return this.getURIForPrefix(term + ":");
    }

    public String getBase() {
        return this.base;
    }

    public String getVocab() {
        return this.vocab;
    }
}

