/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg.manifest;

import java.net.URLConnection;
import java.util.Objects;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.manifest.EncryptionDataElement;
import org.odftoolkit.odfdom.pkg.manifest.FileEntryElement;
import org.odftoolkit.odfdom.pkg.manifest.SizeAttribute;
import org.w3c.dom.Node;

public class OdfFileEntry {
    private FileEntryElement mFileEntryElement;
    private static final String EMPTY_STRING = "";
    private static final String DEFAULT_TYPE = "application/octet-stream";

    public OdfFileEntry(FileEntryElement fileEntryElement) {
        this.mFileEntryElement = fileEntryElement;
    }

    public OdfFileEntry getCopy() {
        return new OdfFileEntry((FileEntryElement)((Object)this.mFileEntryElement.cloneNode(true)));
    }

    public void setPath(String path) {
        this.mFileEntryElement.setFullPathAttribute(path);
    }

    public String getPath() {
        return this.mFileEntryElement.getFullPathAttribute();
    }

    public void setMediaTypeString(String mediaType) {
        this.mFileEntryElement.setMediaTypeAttribute(Objects.requireNonNullElse(mediaType, EMPTY_STRING));
    }

    public String getMediaTypeString() {
        return this.mFileEntryElement.getMediaTypeAttribute();
    }

    public static String getMediaTypeString(String fileRef) {
        String mediaType = null;
        mediaType = URLConnection.guessContentTypeFromName(fileRef);
        if (mediaType == null) {
            mediaType = DEFAULT_TYPE;
        }
        return mediaType;
    }

    public void setSize(Integer size) {
        if (size == null) {
            this.mFileEntryElement.removeAttributeNS(SizeAttribute.ATTRIBUTE_NAME.getUri(), SizeAttribute.ATTRIBUTE_NAME.getLocalName());
        } else {
            this.mFileEntryElement.setSizeAttribute(size);
        }
    }

    public Integer getSize() {
        return this.mFileEntryElement.getSizeAttribute();
    }

    public void setEncryptionData(EncryptionDataElement encryptionData) {
        EncryptionDataElement encryptionDataEle = this.getEncryptionData();
        if (encryptionData != null) {
            if (encryptionDataEle != null) {
                this.mFileEntryElement.replaceChild((Node)((Object)encryptionData), (Node)((Object)encryptionDataEle));
            } else {
                this.mFileEntryElement.appendChild((Node)((Object)encryptionData));
            }
        } else if (encryptionDataEle != null) {
            this.mFileEntryElement.removeChild((Node)((Object)encryptionDataEle));
        }
    }

    public EncryptionDataElement getEncryptionData() {
        return OdfElement.findFirstChildNode(EncryptionDataElement.class, (Node)((Object)this.mFileEntryElement));
    }

    public FileEntryElement getOdfElement() {
        return this.mFileEntryElement;
    }
}

