/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.changes;

import java.util.List;
import org.odftoolkit.odfdom.pkg.OdfElement;

public abstract class TextSelection
implements Comparable<TextSelection> {
    protected List<Integer> mStartPosition;
    protected List<Integer> mEndPosition;
    protected OdfElement mSelectionElement;
    protected String mUrl;

    public List<Integer> getStartPosition() {
        return this.mStartPosition;
    }

    public List<Integer> getEndPosition() {
        return this.mEndPosition;
    }

    public void setEndPosition(List<Integer> endPosition) {
        this.mEndPosition = endPosition;
    }

    public OdfElement getSelectionElement() {
        return this.mSelectionElement;
    }

    public boolean hasUrl() {
        return this.mUrl != null;
    }

    public String getURL() {
        return this.mUrl;
    }

    public void setURL(String url) {
        this.mUrl = url;
    }

    public static boolean overLapping(TextSelection s1, TextSelection s2) {
        boolean isOverlapping = TextSelection.isInbetween(s1.mStartPosition, s2);
        if (!isOverlapping) {
            isOverlapping = TextSelection.isInbetween(s1.mEndPosition, s2);
        }
        if (!isOverlapping && !(isOverlapping = TextSelection.isInbetween(s2.mStartPosition, s1))) {
            isOverlapping = TextSelection.isInbetween(s2.mEndPosition, s1);
        }
        return isOverlapping;
    }

    private static boolean isInbetween(List<Integer> firstPosition, TextSelection s2) {
        boolean isInbetween = false;
        boolean firstPositionIsAfter2ndStart = false;
        boolean firstPositionIsBefore2ndEnd = false;
        if (1 == TextSelection.comparePosition(firstPosition, s2.mStartPosition)) {
            firstPositionIsAfter2ndStart = true;
        }
        if (-1 == TextSelection.comparePosition(firstPosition, s2.mEndPosition)) {
            firstPositionIsBefore2ndEnd = true;
        }
        if (firstPositionIsAfter2ndStart && firstPositionIsBefore2ndEnd) {
            isInbetween = true;
        }
        return isInbetween;
    }

    @Override
    public int compareTo(TextSelection s2) {
        int result = 0;
        result = TextSelection.comparePosition(this.getStartPosition(), s2.getStartPosition());
        if (result == 0) {
            result = TextSelection.comparePosition(this.getEndPosition(), s2.getEndPosition());
        }
        return result;
    }

    private static int comparePosition(List<Integer> pos1, List<Integer> pos2) {
        int result = 0;
        int length1 = pos1.size();
        int length2 = pos2.size();
        int i = 0;
        while (true) {
            int value2;
            int value1;
            if ((value1 = length1 > i ? pos1.get(i) : -1) > (value2 = length2 > i ? pos2.get(i) : -1)) {
                result = 1;
                break;
            }
            if (value2 > value1) {
                result = -1;
                break;
            }
            if (value1 == -1 || value2 == -1) break;
            ++i;
        }
        return result;
    }
}

