/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.changes;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.odftoolkit.odfdom.changes.Component;
import org.odftoolkit.odfdom.changes.JsonOperationConsumer;
import org.odftoolkit.odfdom.changes.MapHelper;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.number.DataStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberBooleanStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTextStyleElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextAElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextParagraphElementBase;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberCurrencyStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberDateStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberPercentageStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberTimeStyle;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class Cell<T>
extends Component {
    private static final Logger LOG = Logger.getLogger(Cell.class.getName());
    private static final String FORMULA_PREFIX = "of:";
    private static final String FLOAT = "float";
    private static final String STRING = "string";
    private static final String CURRENCY = "currency";
    private static final String DATE = "date";
    private static final String TIME = "time";
    private static final String PERCENTAGE = "percentage";
    private static final String BOOLEAN = "boolean";

    public Cell(OdfElement componentElement, Component parent) {
        super(componentElement, parent);
    }

    @Override
    public int repetition() {
        return this.mRootElement.getRepetition();
    }

    @Override
    public void addChild(int index, Component c) {
        this.mRootElement.insert((Node)((Object)c.getRootElement()), index);
    }

    @Override
    public Node getChildNode(int index) {
        return this.mRootElement.receiveNode(index);
    }

    @Override
    public Node remove(int index) {
        Node removedNode = null;
        Node node = this.getChildNode(index);
        if (node != null) {
            removedNode = this.mRootElement.removeChild(node);
        }
        return removedNode;
    }

    @Override
    public int size() {
        return this.mRootElement.componentSize();
    }

    public TableTableCellElement addCellStyleAndContent(Component rootComponent, Object value, JSONObject attrs) {
        TableTableCellElement cell = (TableTableCellElement)this.getRootElement();
        OdfFileDom ownerDoc = (OdfFileDom)((Object)rootComponent.getOwnerDocument());
        String url = Cell.reuseCellHyperlink(cell, attrs);
        boolean setValueType = true;
        boolean isNumberValue = true;
        if (value != null) {
            cell.removeContent();
            if (!value.equals(JSONObject.NULL)) {
                String valueString = value.toString();
                if (valueString.startsWith("=")) {
                    cell.setAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "office:value-type", FLOAT);
                    cell.setAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "table:formula", FORMULA_PREFIX.concat(valueString));
                } else {
                    TextParagraphElementBase newParagraph = JsonOperationConsumer.addParagraph((Component)this, 0, attrs);
                    if (url != null) {
                        attrs = Cell.addUrlToCharacterProps(attrs, url);
                    }
                    if (value instanceof String && valueString.startsWith("'=")) {
                        valueString = valueString.substring(1);
                    }
                    JsonOperationConsumer.addText(newParagraph, 0, attrs, valueString);
                    if (value instanceof Integer || value instanceof Double || value instanceof Float) {
                        isNumberValue = true;
                        cell.setAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "office:value", valueString);
                    } else if (value instanceof String) {
                        cell.setAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "office:value-type", STRING);
                        setValueType = false;
                    }
                }
            }
        }
        if (attrs != null) {
            JsonOperationConsumer.addStyle(attrs, cell, ownerDoc);
            if (cell.hasChildNodes()) {
                NodeList children = cell.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    if (!(child instanceof OdfElement)) continue;
                    ((OdfElement)((Object)child)).markText(0, 0x7FFFFFFE, attrs);
                }
            } else if (url != null) {
                TextPElement containerElement1 = new TextPElement(ownerDoc);
                TextAElement containerElement2 = new TextAElement(ownerDoc);
                containerElement2.setXlinkHrefAttribute(url);
                cell.appendChild((Node)((Object)containerElement1));
                containerElement1.appendChild((Node)((Object)containerElement2));
            }
        }
        if (setValueType) {
            DataStyleElement dataStyle;
            String currentValueType = cell.getOfficeValueTypeAttribute();
            boolean isStringType = currentValueType != null && currentValueType.equals("String");
            boolean changedToNumber = isNumberValue && isStringType;
            boolean numberFormatChanged = false;
            if (attrs != null) {
                JSONObject cellAttrs = attrs.optJSONObject("cell");
                if (cellAttrs != null) {
                    numberFormatChanged = cellAttrs.has("formatCode");
                }
                if (!numberFormatChanged) {
                    String styleId = attrs.optString("styleId");
                    boolean bl = numberFormatChanged = styleId != null;
                }
            }
            if ((currentValueType == null || changedToNumber || numberFormatChanged) && (dataStyle = Cell.getCellDataStyle(cell)) != null) {
                String valueType = "";
                String currencySymbol = "";
                if (dataStyle instanceof OdfNumberStyle) {
                    valueType = FLOAT;
                } else if (dataStyle instanceof OdfNumberCurrencyStyle) {
                    currencySymbol = ((OdfNumberCurrencyStyle)dataStyle).getCurrencySymbolElement().getTextContent();
                    valueType = CURRENCY;
                } else if (dataStyle instanceof NumberTextStyleElement) {
                    valueType = STRING;
                } else if (dataStyle instanceof OdfNumberDateStyle) {
                    valueType = DATE;
                } else if (dataStyle instanceof OdfNumberTimeStyle) {
                    valueType = TIME;
                } else if (dataStyle instanceof OdfNumberPercentageStyle) {
                    valueType = PERCENTAGE;
                } else if (dataStyle instanceof NumberBooleanStyleElement) {
                    valueType = BOOLEAN;
                }
                if (!valueType.isEmpty()) {
                    cell.setOfficeValueTypeAttribute(valueType);
                    cell.setAttributeNS(OdfDocumentNamespace.CALCEXT.getUri(), "calcext:value-type", valueType);
                    cell.setOfficeCurrencyAttribute(currencySymbol);
                    if (value == null && cell.getOfficeValueAttribute() == null) {
                        String oldDateValue = cell.getOfficeDateValueAttribute();
                        String oldTimeValue = cell.getOfficeTimeValueAttribute();
                        Boolean oldBooleanValue = cell.getOfficeBooleanValueAttribute();
                        Double newValue = null;
                        if (oldDateValue != null) {
                            newValue = MapHelper.dateToDouble(oldDateValue);
                        } else if (oldTimeValue != null) {
                            newValue = MapHelper.timeToDouble(oldTimeValue);
                        } else if (oldBooleanValue != null) {
                            newValue = oldBooleanValue != false ? 1 : 0;
                        }
                        if (newValue != null) {
                            cell.setOfficeValueAttribute(newValue);
                        }
                    }
                }
            }
        }
        return cell;
    }

    private static String reuseCellHyperlink(TableTableCellElement cell, JSONObject attrs) {
        OdfStylePropertiesBase textProps;
        OdfStyle autoStyle;
        JSONObject charProps;
        String cellURL = null;
        if (attrs != null && attrs.has("character") && (charProps = attrs.optJSONObject("character")) != null) {
            if (charProps.has("url") && !charProps.get("url").equals(JSONObject.NULL)) {
                cellURL = charProps.optString("url");
            } else if (charProps.has("url")) {
                // empty if block
            }
        }
        if ((cellURL == null || cellURL.isEmpty()) && (autoStyle = cell.getAutomaticStyle()) != null && (textProps = autoStyle.getPropertiesElement(OdfStylePropertiesSet.TextProperties)) != null && textProps.hasAttributeNS(OdfDocumentNamespace.XLINK.getUri(), "href")) {
            cellURL = textProps.getAttributeNS(OdfDocumentNamespace.XLINK.getUri(), "href");
        }
        return cellURL;
    }

    private static JSONObject addUrlToCharacterProps(JSONObject attrs, String cellURL) {
        JSONObject charProps = null;
        if (cellURL != null && !cellURL.isEmpty()) {
            if (attrs == null) {
                attrs = new JSONObject();
            }
            if (!attrs.has("character")) {
                charProps = new JSONObject();
                try {
                    attrs.put("character", (Object)charProps);
                }
                catch (JSONException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            } else {
                charProps = attrs.optJSONObject("character");
            }
            try {
                charProps.put("url", (Object)cellURL);
            }
            catch (JSONException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
        return attrs;
    }

    public static DataStyleElement getCellDataStyle(TableTableCellElement cell) {
        try {
            OdfStyle ownStyle;
            String styleName = cell.getAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "style-name");
            String dataStyleName = "";
            OdfFileDom xDoc = (OdfFileDom)((Object)cell.getOwnerDocument());
            OdfDocument odfDoc = (OdfDocument)xDoc.getDocument();
            OdfOfficeStyles officeStyles = odfDoc.getStylesDom().getOfficeStyles();
            if (styleName == null || styleName.isEmpty()) {
                TableTableRowElement row = (TableTableRowElement)((Object)cell.getParentNode());
                int cellIndex = 0;
                for (TableTableCellElement rowCell = (TableTableCellElement)((Object)row.getFirstChild()); rowCell != null && !rowCell.equals(cell); rowCell = (TableTableCellElement)((Object)rowCell.getNextSibling())) {
                    cellIndex += rowCell.getRepetition();
                }
                Node tableNode = row.getParentNode();
                int colIndex = 0;
                for (TableTableColumnElement columnNode = OdfElement.findFirstChildNode(TableTableColumnElement.class, tableNode); columnNode != null; columnNode = (TableTableColumnElement)((Object)columnNode.getNextSibling())) {
                    TableTableColumnElement column = columnNode;
                    if (colIndex > cellIndex || cellIndex > colIndex + column.getRepetition() - 1) continue;
                    styleName = column.getTableDefaultCellStyleNameAttribute();
                    break;
                }
            }
            if ((ownStyle = officeStyles.getStyle(styleName, OdfStyleFamily.TableCell)) == null) {
                ownStyle = odfDoc.getContentDom().getAutomaticStyles().getStyle(styleName, OdfStyleFamily.TableCell);
            }
            if ((dataStyleName = ownStyle.getAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "data-style-name")) != null) {
                DataStyleElement dataStyle = officeStyles.getAllDataStyles().get(dataStyleName);
                if (dataStyle == null) {
                    dataStyle = odfDoc.getContentDom().getAutomaticStyles().getAllDataStyles().get(dataStyleName);
                }
                return dataStyle;
            }
        }
        catch (IOException | SAXException e) {
            LOG.log(Level.SEVERE, null, e);
        }
        return null;
    }
}

