/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.doc.number;

import org.odftoolkit.odfdom.dom.attribute.number.NumberFormatSourceAttribute;
import org.odftoolkit.odfdom.dom.element.number.NumberAmPmElement;
import org.odftoolkit.odfdom.dom.element.number.NumberDayElement;
import org.odftoolkit.odfdom.dom.element.number.NumberDayOfWeekElement;
import org.odftoolkit.odfdom.dom.element.number.NumberEraElement;
import org.odftoolkit.odfdom.dom.element.number.NumberHoursElement;
import org.odftoolkit.odfdom.dom.element.number.NumberMinutesElement;
import org.odftoolkit.odfdom.dom.element.number.NumberMonthElement;
import org.odftoolkit.odfdom.dom.element.number.NumberQuarterElement;
import org.odftoolkit.odfdom.dom.element.number.NumberSecondsElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTextElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTimeStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberYearElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.Node;

public class OdfNumberTimeStyle
extends NumberTimeStyleElement {
    private String styleName;
    private String formatCode;

    public OdfNumberTimeStyle(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    public OdfNumberTimeStyle(OdfFileDom ownerDoc, String format, String styleName) {
        super(ownerDoc);
        this.styleName = styleName;
        this.formatCode = format;
        this.setFormat(format);
    }

    @Override
    public String getFormat(boolean capsDateFormat) {
        if (this.formatCode == null) {
            this.formatCode = "";
            String truncate = this.getAttribute("number:truncate-on-overflow");
            boolean setBrackets = false;
            if (truncate != null && truncate.equals("false")) {
                setBrackets = true;
            }
            for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
                String numberstyle;
                OdfElement ele;
                if (!(child instanceof OdfElement)) continue;
                if (child instanceof NumberDayElement) {
                    ele = (NumberDayElement)((Object)child);
                    numberstyle = ((NumberDayElement)ele).getNumberStyleAttribute();
                    if (numberstyle != null && numberstyle.equals("long")) {
                        this.formatCode = this.formatCode + (capsDateFormat ? "DD" : "dd");
                        continue;
                    }
                    this.formatCode = this.formatCode + (capsDateFormat ? "D" : "d");
                    continue;
                }
                if (child instanceof NumberMonthElement) {
                    ele = (NumberMonthElement)((Object)child);
                    numberstyle = ((NumberMonthElement)ele).getNumberStyleAttribute();
                    if (((NumberMonthElement)ele).getNumberTextualAttribute().booleanValue()) {
                        if (numberstyle != null && numberstyle.equals("long")) {
                            this.formatCode = this.formatCode + "MMMM";
                            continue;
                        }
                        this.formatCode = this.formatCode + "MMM";
                        continue;
                    }
                    if (numberstyle != null && numberstyle.equals("long")) {
                        this.formatCode = this.formatCode + "MM";
                        continue;
                    }
                    this.formatCode = this.formatCode + "M";
                    continue;
                }
                if (child instanceof NumberYearElement) {
                    ele = (NumberYearElement)((Object)child);
                    numberstyle = ((NumberYearElement)ele).getNumberStyleAttribute();
                    if (numberstyle != null && numberstyle.equals("long")) {
                        this.formatCode = this.formatCode + (capsDateFormat ? "YYYY" : "yyyy");
                        continue;
                    }
                    this.formatCode = this.formatCode + (capsDateFormat ? "YY" : "yy");
                    continue;
                }
                if (child instanceof NumberTextElement) {
                    String content = child.getTextContent();
                    if (content == null || content.equals("")) {
                        this.formatCode = this.formatCode + " ";
                        continue;
                    }
                    this.formatCode = this.formatCode + content;
                    continue;
                }
                if (child instanceof NumberEraElement) {
                    ele = (NumberEraElement)((Object)child);
                    numberstyle = ((NumberEraElement)ele).getNumberStyleAttribute();
                    if (numberstyle != null && numberstyle.equals("long")) {
                        this.formatCode = this.formatCode + "GGGG";
                        continue;
                    }
                    this.formatCode = this.formatCode + "GG";
                    continue;
                }
                if (child instanceof NumberHoursElement) {
                    ele = (NumberHoursElement)((Object)child);
                    numberstyle = ((NumberHoursElement)ele).getNumberStyleAttribute();
                    if (setBrackets) {
                        this.formatCode = this.formatCode + "[";
                    }
                    this.formatCode = numberstyle != null && numberstyle.equals("long") ? this.formatCode + (capsDateFormat ? "HH" : "hh") : this.formatCode + (capsDateFormat ? "H" : "h");
                    if (!setBrackets) continue;
                    this.formatCode = this.formatCode + "]";
                    setBrackets = false;
                    continue;
                }
                if (child instanceof NumberMinutesElement) {
                    if (setBrackets) {
                        this.formatCode = this.formatCode + "[";
                    }
                    this.formatCode = (numberstyle = ((NumberMinutesElement)(ele = (NumberMinutesElement)((Object)child))).getNumberStyleAttribute()) != null && numberstyle.equals("long") ? this.formatCode + "mm" : this.formatCode + "m";
                    if (!setBrackets) continue;
                    this.formatCode = this.formatCode + "]";
                    setBrackets = false;
                    continue;
                }
                if (child instanceof NumberSecondsElement) {
                    if (setBrackets) {
                        this.formatCode = this.formatCode + "[";
                    }
                    this.formatCode = (numberstyle = ((NumberSecondsElement)(ele = (NumberSecondsElement)((Object)child))).getNumberStyleAttribute()) != null && numberstyle.equals("long") ? this.formatCode + (capsDateFormat ? "SS" : "ss") : this.formatCode + (capsDateFormat ? "SS" : "s");
                    Integer decimals = ((NumberSecondsElement)ele).getNumberDecimalPlacesAttribute();
                    if (decimals != null && decimals > 0) {
                        this.formatCode = this.formatCode + ".";
                        for (int i = 0; i < decimals; ++i) {
                            this.formatCode = this.formatCode + "0";
                        }
                    }
                    if (!setBrackets) continue;
                    this.formatCode = this.formatCode + "]";
                    setBrackets = false;
                    continue;
                }
                if (child instanceof NumberQuarterElement) {
                    ele = (NumberQuarterElement)((Object)child);
                    numberstyle = ((NumberQuarterElement)ele).getNumberStyleAttribute();
                    if (numberstyle != null && numberstyle.equals("long")) {
                        this.formatCode = this.formatCode + "QQQ";
                        continue;
                    }
                    this.formatCode = this.formatCode + "Q";
                    continue;
                }
                if (child instanceof NumberDayOfWeekElement) {
                    ele = (NumberDayOfWeekElement)((Object)child);
                    numberstyle = ((NumberDayOfWeekElement)ele).getNumberStyleAttribute();
                    if (numberstyle != null && numberstyle.equals("long")) {
                        this.formatCode = this.formatCode + "EEEE";
                        continue;
                    }
                    this.formatCode = this.formatCode + "EEE";
                    continue;
                }
                if (!(child instanceof NumberAmPmElement)) continue;
                this.formatCode = this.formatCode + "AM/PM";
            }
        }
        return this.formatCode;
    }

    @Override
    public void setFormat(String format) {
        String actionChars = "GyQMwdEHhms";
        int actionCount = 0;
        Object textBuffer = "";
        boolean endQuote = false;
        int i = 0;
        this.setStyleNameAttribute(this.styleName);
        this.setNumberFormatSourceAttribute(NumberFormatSourceAttribute.Value.LANGUAGE.toString());
        while (i < format.length()) {
            char ch = format.charAt(i);
            if (actionChars.indexOf(ch) >= 0) {
                this.appendText((String)textBuffer);
                textBuffer = "";
                actionCount = 0;
                while (i < format.length() && format.charAt(i) == ch) {
                    ++actionCount;
                    ++i;
                }
                this.processChar(ch, actionCount);
                continue;
            }
            if (ch == '\'') {
                endQuote = false;
                ++i;
                while (i < format.length() && !endQuote) {
                    ch = format.charAt(i);
                    if (ch == '\'') {
                        if (i + 1 < format.length() && format.charAt(i + 1) == '\'') {
                            ++i;
                            textBuffer = (String)textBuffer + "'";
                        } else {
                            endQuote = true;
                        }
                    } else {
                        textBuffer = (String)textBuffer + ch;
                    }
                    ++i;
                }
                continue;
            }
            if (ch == 'A' && format.startsWith("AM/PM", i)) {
                this.appendText((String)textBuffer);
                textBuffer = "";
                NumberAmPmElement ampm = new NumberAmPmElement((OdfFileDom)((Object)this.getOwnerDocument()));
                this.appendChild((Node)((Object)ampm));
                i += 5;
                continue;
            }
            textBuffer = (String)textBuffer + ch;
            ++i;
        }
        this.appendText((String)textBuffer);
    }

    private void appendText(String textBuffer) {
        NumberTextElement textElement = null;
        if (!textBuffer.equals("")) {
            textElement = new NumberTextElement((OdfFileDom)((Object)this.getOwnerDocument()));
            textElement.setTextContent(textBuffer);
            this.appendChild((Node)((Object)textElement));
        }
    }

    private void processChar(char ch, int count) {
        OdfFileDom ownerDoc = (OdfFileDom)((Object)this.getOwnerDocument());
        switch (ch) {
            case 'H': 
            case 'h': {
                NumberHoursElement hours = new NumberHoursElement(ownerDoc);
                hours.setNumberStyleAttribute(this.isLongIf(count > 1));
                this.appendChild((Node)((Object)hours));
                break;
            }
            case 'M': 
            case 'm': {
                NumberMinutesElement minutes = new NumberMinutesElement(ownerDoc);
                minutes.setNumberStyleAttribute(this.isLongIf(count > 1));
                this.appendChild((Node)((Object)minutes));
                break;
            }
            case 'S': 
            case 's': {
                NumberSecondsElement seconds = new NumberSecondsElement(ownerDoc);
                seconds.setNumberStyleAttribute(this.isLongIf(count > 1));
                this.appendChild((Node)((Object)seconds));
            }
        }
    }

    private String isLongIf(boolean isLong) {
        return isLong ? "long" : "short";
    }
}

