/**
 * **********************************************************************
 *
 * <p>DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * <p>Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * <p>Use is subject to license terms.
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0. You can also obtain a copy of the License at
 * http://odftoolkit.org/docs/license.txt
 *
 * <p>Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 *
 * <p>See the License for the specific language governing permissions and limitations under the
 * License.
 *
 * <p>**********************************************************************
 */

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.chart;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartDimensionAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartStyleNameAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

/** DOM implementation of OpenDocument element {@odf.element chart:axis}. */
public class ChartAxisElement extends OdfStylableElement {

  public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.CHART, "axis");

  /**
   * Create the instance of <code>ChartAxisElement</code>
   *
   * @param ownerDoc The type is <code>OdfFileDom</code>
   */
  public ChartAxisElement(OdfFileDom ownerDoc) {
    super(
        ownerDoc,
        ELEMENT_NAME,
        OdfStyleFamily.Chart,
        OdfName.newName(OdfDocumentNamespace.CHART, "style-name"));
  }

  /**
   * Get the element name
   *
   * @return return <code>OdfName</code> the name of element {@odf.element chart:axis}.
   */
  public OdfName getOdfName() {
    return ELEMENT_NAME;
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>ChartDimensionAttribute</code>
   * , See {@odf.attribute chart:dimension}
   *
   * <p>Attribute is mandatory.
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getChartDimensionAttribute() {
    ChartDimensionAttribute attr =
        (ChartDimensionAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "dimension");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>ChartDimensionAttribute</code> , See
   * {@odf.attribute chart:dimension}
   *
   * @param chartDimensionValue The type is <code>String</code>
   */
  public void setChartDimensionAttribute(String chartDimensionValue) {
    ChartDimensionAttribute attr = new ChartDimensionAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(chartDimensionValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>ChartNameAttribute</code> , See
   * {@odf.attribute chart:name}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getChartNameAttribute() {
    ChartNameAttribute attr =
        (ChartNameAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "name");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>ChartNameAttribute</code> , See
   * {@odf.attribute chart:name}
   *
   * @param chartNameValue The type is <code>String</code>
   */
  public void setChartNameAttribute(String chartNameValue) {
    ChartNameAttribute attr = new ChartNameAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(chartNameValue);
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>ChartStyleNameAttribute</code>
   * , See {@odf.attribute chart:style-name}
   *
   * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set
   *     and no default value defined.
   */
  public String getChartStyleNameAttribute() {
    ChartStyleNameAttribute attr =
        (ChartStyleNameAttribute) getOdfAttribute(OdfDocumentNamespace.CHART, "style-name");
    if (attr != null) {
      return String.valueOf(attr.getValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>ChartStyleNameAttribute</code> , See
   * {@odf.attribute chart:style-name}
   *
   * @param chartStyleNameValue The type is <code>String</code>
   */
  public void setChartStyleNameAttribute(String chartStyleNameValue) {
    ChartStyleNameAttribute attr = new ChartStyleNameAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setValue(chartStyleNameValue);
  }

  /**
   * Create child element {@odf.element chart:categories}.
   *
   * @return the element {@odf.element chart:categories}
   */
  public ChartCategoriesElement newChartCategoriesElement() {
    ChartCategoriesElement chartCategories =
        ((OdfFileDom) this.ownerDocument).newOdfElement(ChartCategoriesElement.class);
    this.appendChild(chartCategories);
    return chartCategories;
  }

  /**
   * Create child element {@odf.element chart:grid}.
   *
   * @return the element {@odf.element chart:grid}
   */
  public ChartGridElement newChartGridElement() {
    ChartGridElement chartGrid =
        ((OdfFileDom) this.ownerDocument).newOdfElement(ChartGridElement.class);
    this.appendChild(chartGrid);
    return chartGrid;
  }

  /**
   * Create child element {@odf.element chart:title}.
   *
   * @return the element {@odf.element chart:title}
   */
  public ChartTitleElement newChartTitleElement() {
    ChartTitleElement chartTitle =
        ((OdfFileDom) this.ownerDocument).newOdfElement(ChartTitleElement.class);
    this.appendChild(chartTitle);
    return chartTitle;
  }

  @Override
  public void accept(ElementVisitor visitor) {
    if (visitor instanceof DefaultElementVisitor) {
      DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
      defaultVisitor.visit(this);
    } else {
      visitor.visit(this);
    }
  }
}
