/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.urlbuilder;

import java.util.Arrays;
import java.util.List;
import org.ocpsoft.urlbuilder.util.Encoder;

class Parameter {
    private final CharSequence name;
    private final List<Object> values;
    private final boolean encode;

    private Parameter(CharSequence name, boolean encode, List<Object> values) {
        this.name = name;
        this.encode = encode;
        this.values = values;
    }

    public static Parameter create(CharSequence name, Object ... values) {
        return new Parameter(name, true, Arrays.asList(values));
    }

    public static Parameter create(CharSequence name, boolean encode, Object ... values) {
        return new Parameter(name, encode, Arrays.asList(values));
    }

    public CharSequence getName() {
        return this.name;
    }

    public boolean isEncode() {
        return this.encode;
    }

    public boolean hasValues() {
        return !this.values.isEmpty();
    }

    public int getValueCount() {
        return this.values.size();
    }

    public String getValueAsPathParam(int index) {
        if (this.encode) {
            return Encoder.path(this.values.get(index).toString());
        }
        return this.values.get(index).toString();
    }

    public String getValueAsQueryParam(int index) {
        Object value = this.values.get(index);
        if (this.encode) {
            return Encoder.query(value == null ? null : value.toString());
        }
        return value == null ? null : value.toString();
    }
}

