/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.config;

import org.ocpsoft.rewrite.config.DefaultOperationBuilder;
import org.ocpsoft.rewrite.config.InboundOperation;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.OperationBuilder;
import org.ocpsoft.rewrite.config.OutboundOperation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.InboundRewrite;
import org.ocpsoft.rewrite.event.OutboundRewrite;
import org.ocpsoft.rewrite.event.Rewrite;

public class Operations {
    public static OperationBuilder create() {
        return new NoOp();
    }

    public static Operation onInbound(final Operation operation) {
        return new InboundOperation(){

            @Override
            public void performInbound(InboundRewrite event, EvaluationContext context) {
                operation.perform(event, context);
            }
        };
    }

    public static Operation onOutbound(final Operation operation) {
        return new OutboundOperation(){

            @Override
            public void performOutbound(OutboundRewrite event, EvaluationContext context) {
                operation.perform(event, context);
            }
        };
    }

    public static OperationBuilder wrap(Operation operation) {
        if (operation == null) {
            return Operations.create();
        }
        if (operation instanceof OperationBuilder) {
            return (OperationBuilder)operation;
        }
        return new DefaultOperationBuilder.DefaultCompositeOperation(Operations.create(), operation);
    }

    public static class NoOp
    extends DefaultOperationBuilder {
        @Override
        public void perform(Rewrite event, EvaluationContext context) {
        }

        public String toString() {
            return "NoOp";
        }
    }
}

