/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.annotation.scan;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.servlet.ServletContext;
import org.ocpsoft.rewrite.annotation.api.ClassVisitor;
import org.ocpsoft.rewrite.annotation.scan.AbstractClassFinder;
import org.ocpsoft.rewrite.annotation.scan.ByteCodeFilter;
import org.ocpsoft.rewrite.annotation.scan.PackageFilter;

public class WebLibFinder
extends AbstractClassFinder {
    private static final String LIB_FOLDER = "/WEB-INF/lib/";

    public WebLibFinder(ServletContext servletContext, ClassLoader classLoader, PackageFilter packageFilter, ByteCodeFilter byteCodeFilter) {
        super(servletContext, classLoader, packageFilter, byteCodeFilter);
    }

    public void findClasses(ClassVisitor visitor) {
        try {
            URL libFolderUrl = this.servletContext.getResource(LIB_FOLDER);
            if (libFolderUrl == null) {
                this.log.warn("Cannot find /WEB-INF/lib/ folder!");
                return;
            }
            Set paths = this.servletContext.getResourcePaths(LIB_FOLDER);
            for (Object relativePath : paths) {
                URL entryUrl = this.servletContext.getResource(relativePath.toString());
                if (!entryUrl.getPath().endsWith(".jar")) continue;
                this.processJarFile(entryUrl, visitor);
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid URL: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJarFile(URL jarUrl, ClassVisitor visitor) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Processing JAR file: " + jarUrl.toString());
        }
        JarInputStream jarStream = null;
        try {
            jarStream = new JarInputStream(jarUrl.openStream());
            JarEntry jarEntry = null;
            while ((jarEntry = jarStream.getNextJarEntry()) != null) {
                String className;
                if (!jarEntry.getName().endsWith(".class") || !this.mustProcessClass(className = WebLibFinder.getClassName(jarEntry.getName()))) continue;
                this.processClass(className, jarStream, visitor);
            }
        }
        catch (IOException e) {
            this.log.error("Failed to read JAR file: " + jarUrl.toString(), (Throwable)e);
        }
        finally {
            if (jarStream != null) {
                try {
                    jarStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public int priority() {
        return 0;
    }
}

