/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.shade.net.fortuna.ical4j.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.text.ParseException;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.data.CalendarParser;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.data.ContentHandler;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.data.ParserException;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.data.UnfoldingReader;
import org.ocpsoft.prettytime.shade.org.apache.commons.logging.Log;
import org.ocpsoft.prettytime.shade.org.apache.commons.logging.LogFactory;

public class CalendarParserImpl
implements CalendarParser {
    private static final int WORD_CHAR_START = 32;
    private static final int WORD_CHAR_END = 255;
    private static final int WHITESPACE_CHAR_START = 0;
    private static final int WHITESPACE_CHAR_END = 20;
    private static final String UNEXPECTED_TOKEN_MESSAGE = "Expected [{0}], read [{1}]";
    private Log log = LogFactory.getLog(CalendarParserImpl.class);
    private final ComponentListParser componentListParser = new ComponentListParser();
    private final ComponentParser componentParser = new ComponentParser();
    private final PropertyListParser propertyListParser = new PropertyListParser();
    private final PropertyParser propertyParser = new PropertyParser();
    private final ParameterListParser paramListParser = new ParameterListParser();
    private final ParameterParser paramParser = new ParameterParser();

    public final void parse(InputStream in, ContentHandler handler) throws IOException, ParserException {
        this.parse(new InputStreamReader(in), handler);
    }

    public final void parse(Reader in, ContentHandler handler) throws IOException, ParserException {
        StreamTokenizer tokeniser = new StreamTokenizer(in);
        try {
            tokeniser.resetSyntax();
            tokeniser.wordChars(32, 255);
            tokeniser.whitespaceChars(0, 20);
            tokeniser.ordinaryChar(58);
            tokeniser.ordinaryChar(59);
            tokeniser.ordinaryChar(61);
            tokeniser.ordinaryChar(9);
            tokeniser.eolIsSignificant(true);
            tokeniser.whitespaceChars(0, 0);
            tokeniser.quoteChar(34);
            this.assertToken(tokeniser, in, "BEGIN");
            this.assertToken(tokeniser, in, 58);
            this.assertToken(tokeniser, in, "VCALENDAR", true);
            this.assertToken(tokeniser, in, 10);
            handler.startCalendar();
            this.propertyListParser.parse(tokeniser, in, handler);
            this.componentListParser.parse(tokeniser, in, handler);
            this.assertToken(tokeniser, in, 58);
            this.assertToken(tokeniser, in, "VCALENDAR", true);
            handler.endCalendar();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ParserException) {
                throw (ParserException)e;
            }
            throw new ParserException(e.getMessage(), this.getLineNumber(tokeniser, in), e);
        }
    }

    private void assertToken(StreamTokenizer tokeniser, Reader in, int token) throws IOException, ParserException {
        if (tokeniser.nextToken() != token) {
            throw new ParserException(MessageFormat.format(UNEXPECTED_TOKEN_MESSAGE, new Integer(token), new Integer(tokeniser.ttype)), this.getLineNumber(tokeniser, in));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("[" + token + "]");
        }
    }

    private void assertToken(StreamTokenizer tokeniser, Reader in, String token) throws IOException, ParserException {
        this.assertToken(tokeniser, in, token, false);
    }

    private void assertToken(StreamTokenizer tokeniser, Reader in, String token, boolean ignoreCase) throws IOException, ParserException {
        this.assertToken(tokeniser, in, -3);
        if (ignoreCase ? !token.equalsIgnoreCase(tokeniser.sval) : !token.equals(tokeniser.sval)) {
            throw new ParserException(MessageFormat.format(UNEXPECTED_TOKEN_MESSAGE, token, tokeniser.sval), this.getLineNumber(tokeniser, in));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("[" + token + "]");
        }
    }

    private void absorbWhitespace(StreamTokenizer tokeniser) throws IOException {
        while (tokeniser.nextToken() == 10) {
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace("Absorbing extra whitespace..");
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Aborting: absorbing extra whitespace complete");
        }
    }

    private int getLineNumber(StreamTokenizer tokeniser, Reader in) {
        int line = tokeniser.lineno();
        if (tokeniser.ttype == 10) {
            --line;
        }
        if (in instanceof UnfoldingReader) {
            int unfolded = ((UnfoldingReader)in).getLinesUnfolded();
            line += unfolded;
        }
        return line;
    }

    private class ComponentParser {
        private ComponentParser() {
        }

        private void parse(StreamTokenizer tokeniser, Reader in, ContentHandler handler) throws IOException, ParseException, URISyntaxException, ParserException {
            CalendarParserImpl.this.assertToken(tokeniser, in, 58);
            CalendarParserImpl.this.assertToken(tokeniser, in, -3);
            String name = tokeniser.sval;
            handler.startComponent(name);
            CalendarParserImpl.this.assertToken(tokeniser, in, 10);
            CalendarParserImpl.this.propertyListParser.parse(tokeniser, in, handler);
            CalendarParserImpl.this.assertToken(tokeniser, in, 58);
            CalendarParserImpl.this.assertToken(tokeniser, in, name);
            CalendarParserImpl.this.assertToken(tokeniser, in, 10);
            handler.endComponent(name);
        }
    }

    private class ComponentListParser {
        private ComponentListParser() {
        }

        private void parse(StreamTokenizer tokeniser, Reader in, ContentHandler handler) throws IOException, ParseException, URISyntaxException, ParserException {
            while ("BEGIN".equals(tokeniser.sval)) {
                CalendarParserImpl.this.componentParser.parse(tokeniser, in, handler);
                CalendarParserImpl.this.absorbWhitespace(tokeniser);
            }
        }
    }

    private class ParameterParser {
        private ParameterParser() {
        }

        private void parse(StreamTokenizer tokeniser, Reader in, ContentHandler handler) throws IOException, ParserException, URISyntaxException {
            CalendarParserImpl.this.assertToken(tokeniser, in, -3);
            String paramName = tokeniser.sval;
            if (CalendarParserImpl.this.log.isDebugEnabled()) {
                CalendarParserImpl.this.log.debug("Parameter [" + paramName + "]");
            }
            CalendarParserImpl.this.assertToken(tokeniser, in, 61);
            StringBuffer paramValue = new StringBuffer();
            if (tokeniser.nextToken() == 34) {
                paramValue.append('\"');
                paramValue.append(tokeniser.sval);
                paramValue.append('\"');
            } else if (tokeniser.sval != null) {
                paramValue.append(tokeniser.sval);
                int nextToken = tokeniser.nextToken();
                while (nextToken != 59 && nextToken != 58 && nextToken != 44) {
                    if (tokeniser.ttype == -3) {
                        paramValue.append(tokeniser.sval);
                    } else {
                        paramValue.append((char)tokeniser.ttype);
                    }
                    nextToken = tokeniser.nextToken();
                }
                tokeniser.pushBack();
            } else if (tokeniser.sval == null) {
                tokeniser.pushBack();
            }
            try {
                handler.parameter(paramName, paramValue.toString());
            }
            catch (ClassCastException cce) {
                throw new ParserException("Error parsing parameter", CalendarParserImpl.this.getLineNumber(tokeniser, in), cce);
            }
        }
    }

    private class ParameterListParser {
        private ParameterListParser() {
        }

        public void parse(StreamTokenizer tokeniser, Reader in, ContentHandler handler) throws IOException, ParserException, URISyntaxException {
            while (tokeniser.nextToken() == 59) {
                CalendarParserImpl.this.paramParser.parse(tokeniser, in, handler);
            }
        }
    }

    private class PropertyParser {
        private static final String PARSE_DEBUG_MESSAGE = "Property [{0}]";
        private static final String PARSE_EXCEPTION_MESSAGE = "Property [{0}]";

        private PropertyParser() {
        }

        private void parse(StreamTokenizer tokeniser, Reader in, ContentHandler handler) throws IOException, ParserException, URISyntaxException, ParseException {
            String name = tokeniser.sval;
            if (CalendarParserImpl.this.log.isDebugEnabled()) {
                CalendarParserImpl.this.log.debug(MessageFormat.format("Property [{0}]", name));
            }
            handler.startProperty(name);
            CalendarParserImpl.this.paramListParser.parse(tokeniser, in, handler);
            StringBuffer value = new StringBuffer();
            tokeniser.ordinaryChar(34);
            int nextToken = tokeniser.nextToken();
            while (nextToken != 10 && nextToken != -1) {
                if (tokeniser.ttype == -3) {
                    value.append(tokeniser.sval);
                } else {
                    value.append((char)tokeniser.ttype);
                }
                nextToken = tokeniser.nextToken();
            }
            tokeniser.quoteChar(34);
            if (nextToken == -1) {
                throw new ParserException("Unexpected end of file", CalendarParserImpl.this.getLineNumber(tokeniser, in));
            }
            try {
                handler.propertyValue(value.toString());
            }
            catch (ParseException e) {
                ParseException eNew = new ParseException("[" + name + "] " + e.getMessage(), e.getErrorOffset());
                eNew.initCause(e);
                throw eNew;
            }
            handler.endProperty(name);
        }
    }

    private class PropertyListParser {
        private PropertyListParser() {
        }

        public void parse(StreamTokenizer tokeniser, Reader in, ContentHandler handler) throws IOException, ParseException, URISyntaxException, ParserException {
            CalendarParserImpl.this.assertToken(tokeniser, in, -3);
            while (!"END".equals(tokeniser.sval)) {
                if ("BEGIN".equals(tokeniser.sval)) {
                    CalendarParserImpl.this.componentParser.parse(tokeniser, in, handler);
                } else {
                    CalendarParserImpl.this.propertyParser.parse(tokeniser, in, handler);
                }
                CalendarParserImpl.this.absorbWhitespace(tokeniser);
            }
        }
    }
}

