/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.shade.org.antlr.stringtemplate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.ocpsoft.prettytime.shade.org.antlr.stringtemplate.StringTemplateErrorListener;
import org.ocpsoft.prettytime.shade.org.antlr.stringtemplate.StringTemplateGroup;
import org.ocpsoft.prettytime.shade.org.antlr.stringtemplate.StringTemplateGroupInterface;
import org.ocpsoft.prettytime.shade.org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.ocpsoft.prettytime.shade.org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class PathGroupLoader
implements StringTemplateGroupLoader {
    protected List dirs = null;
    protected StringTemplateErrorListener errors = null;
    String fileCharEncoding = System.getProperty("file.encoding");

    public PathGroupLoader(StringTemplateErrorListener stringTemplateErrorListener) {
        this.errors = stringTemplateErrorListener;
    }

    public PathGroupLoader(String string, StringTemplateErrorListener stringTemplateErrorListener) {
        this.errors = stringTemplateErrorListener;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":", false);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (this.dirs == null) {
                this.dirs = new ArrayList();
            }
            this.dirs.add(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringTemplateGroup loadGroup(String string, Class clazz, StringTemplateGroup stringTemplateGroup) {
        Class clazz2;
        StringTemplateGroup stringTemplateGroup2 = null;
        BufferedReader bufferedReader = null;
        Class clazz3 = clazz2 = AngleBracketTemplateLexer.class;
        if (clazz != null) {
            clazz2 = clazz;
        }
        try {
            bufferedReader = this.locate(string + ".stg");
            if (bufferedReader == null) {
                this.error("no such group file " + string + ".stg");
                StringTemplateGroup stringTemplateGroup3 = null;
                return stringTemplateGroup3;
            }
            stringTemplateGroup2 = new StringTemplateGroup(bufferedReader, clazz2, this.errors, stringTemplateGroup);
            bufferedReader.close();
            bufferedReader = null;
        }
        catch (IOException iOException) {
            this.error("can't load group " + string, iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    this.error("Cannot close template group file: " + string + ".stg", iOException);
                }
            }
        }
        return stringTemplateGroup2;
    }

    public StringTemplateGroup loadGroup(String string, StringTemplateGroup stringTemplateGroup) {
        return this.loadGroup(string, null, stringTemplateGroup);
    }

    public StringTemplateGroup loadGroup(String string) {
        return this.loadGroup(string, null);
    }

    public StringTemplateGroupInterface loadInterface(String string) {
        StringTemplateGroupInterface stringTemplateGroupInterface = null;
        try {
            BufferedReader bufferedReader = this.locate(string + ".sti");
            if (bufferedReader == null) {
                this.error("no such interface file " + string + ".sti");
                return null;
            }
            stringTemplateGroupInterface = new StringTemplateGroupInterface(bufferedReader, this.errors);
        }
        catch (IOException iOException) {
            this.error("can't load interface " + string, iOException);
        }
        return stringTemplateGroupInterface;
    }

    protected BufferedReader locate(String string) throws IOException {
        for (int i = 0; i < this.dirs.size(); ++i) {
            String string2 = (String)this.dirs.get(i);
            String string3 = string2 + "/" + string;
            if (!new File(string3).exists()) continue;
            FileInputStream fileInputStream = new FileInputStream(string3);
            InputStreamReader inputStreamReader = this.getInputStreamReader(fileInputStream);
            return new BufferedReader(inputStreamReader);
        }
        return null;
    }

    protected InputStreamReader getInputStreamReader(InputStream inputStream) {
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, this.fileCharEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.error("Invalid file character encoding: " + this.fileCharEncoding);
        }
        return inputStreamReader;
    }

    public String getFileCharEncoding() {
        return this.fileCharEncoding;
    }

    public void setFileCharEncoding(String string) {
        this.fileCharEncoding = string;
    }

    public void error(String string) {
        this.error(string, null);
    }

    public void error(String string, Exception exception) {
        if (this.errors != null) {
            this.errors.error(string, exception);
        } else {
            System.err.println("StringTemplate: " + string);
            if (exception != null) {
                exception.printStackTrace();
            }
        }
    }
}

