/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.property;

import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.ParameterList;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.Property;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.PropertyFactoryImpl;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.ValidationException;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.util.CompatibilityHints;

public class CalScale
extends Property {
    private static final long serialVersionUID = 7446184786984981423L;
    public static final CalScale GREGORIAN = new ImmutableCalScale("GREGORIAN");
    private String value;

    public CalScale() {
        super("CALSCALE", PropertyFactoryImpl.getInstance());
    }

    public CalScale(String aValue) {
        super("CALSCALE", PropertyFactoryImpl.getInstance());
        this.value = aValue;
    }

    public CalScale(ParameterList aList, String aValue) {
        super("CALSCALE", aList, PropertyFactoryImpl.getInstance());
        this.value = aValue;
    }

    public void setValue(String aValue) {
        this.value = aValue;
    }

    public final String getValue() {
        return this.value;
    }

    public final void validate() throws ValidationException {
        if (CompatibilityHints.isHintEnabled("ical4j.validation.relaxed") ? !GREGORIAN.getValue().equalsIgnoreCase(this.value) : !GREGORIAN.getValue().equals(this.value)) {
            throw new ValidationException("Invalid value [" + this.value + "]");
        }
    }

    private static final class ImmutableCalScale
    extends CalScale {
        private static final long serialVersionUID = 1750949550694413878L;

        private ImmutableCalScale(String value) {
            super(new ParameterList(true), value);
        }

        public void setValue(String aValue) {
            throw new UnsupportedOperationException("Cannot modify constant instances");
        }
    }
}

