/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model;

import java.io.Serializable;
import java.util.Calendar;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.util.Numbers;
import org.ocpsoft.prettytime.shade.org.apache.commons.lang.ObjectUtils;
import org.ocpsoft.prettytime.shade.org.apache.commons.lang.builder.HashCodeBuilder;

public class WeekDay
implements Serializable {
    private static final long serialVersionUID = -4412000990022011469L;
    public static final WeekDay SU = new WeekDay("SU", 0);
    public static final WeekDay MO = new WeekDay("MO", 0);
    public static final WeekDay TU = new WeekDay("TU", 0);
    public static final WeekDay WE = new WeekDay("WE", 0);
    public static final WeekDay TH = new WeekDay("TH", 0);
    public static final WeekDay FR = new WeekDay("FR", 0);
    public static final WeekDay SA = new WeekDay("SA", 0);
    private String day;
    private int offset;

    public WeekDay(String value) {
        this.offset = value.length() > 2 ? Numbers.parseInt(value.substring(0, value.length() - 2)) : 0;
        this.day = value.substring(value.length() - 2);
        this.validateDay();
    }

    private WeekDay(String day, int offset) {
        this.day = day;
        this.offset = offset;
    }

    public WeekDay(WeekDay weekDay, int offset) {
        this.day = weekDay.getDay();
        this.offset = offset;
    }

    private void validateDay() {
        if (!(WeekDay.SU.day.equals(this.day) || WeekDay.MO.day.equals(this.day) || WeekDay.TU.day.equals(this.day) || WeekDay.WE.day.equals(this.day) || WeekDay.TH.day.equals(this.day) || WeekDay.FR.day.equals(this.day) || WeekDay.SA.day.equals(this.day))) {
            throw new IllegalArgumentException("Invalid day: " + this.day);
        }
    }

    public final String getDay() {
        return this.day;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final String toString() {
        StringBuffer b = new StringBuffer();
        if (this.getOffset() != 0) {
            b.append(this.getOffset());
        }
        b.append(this.getDay());
        return b.toString();
    }

    public static final WeekDay getWeekDay(Calendar cal) {
        return new WeekDay(WeekDay.getDay(cal.get(7)), 0);
    }

    public static final WeekDay getMonthlyOffset(Calendar cal) {
        return new WeekDay(WeekDay.getDay(cal.get(7)), cal.get(8));
    }

    public static final WeekDay getNegativeMonthlyOffset(Calendar cal) {
        return new WeekDay(WeekDay.getDay(cal.get(7)), cal.get(8) - 6);
    }

    public static WeekDay getDay(int calDay) {
        WeekDay day = null;
        switch (calDay) {
            case 1: {
                day = SU;
                break;
            }
            case 2: {
                day = MO;
                break;
            }
            case 3: {
                day = TU;
                break;
            }
            case 4: {
                day = WE;
                break;
            }
            case 5: {
                day = TH;
                break;
            }
            case 6: {
                day = FR;
                break;
            }
            case 7: {
                day = SA;
                break;
            }
        }
        return day;
    }

    public static int getCalendarDay(WeekDay weekday) {
        int calendarDay = -1;
        if (SU.getDay().equals(weekday.getDay())) {
            calendarDay = 1;
        } else if (MO.getDay().equals(weekday.getDay())) {
            calendarDay = 2;
        } else if (TU.getDay().equals(weekday.getDay())) {
            calendarDay = 3;
        } else if (WE.getDay().equals(weekday.getDay())) {
            calendarDay = 4;
        } else if (TH.getDay().equals(weekday.getDay())) {
            calendarDay = 5;
        } else if (FR.getDay().equals(weekday.getDay())) {
            calendarDay = 6;
        } else if (SA.getDay().equals(weekday.getDay())) {
            calendarDay = 7;
        }
        return calendarDay;
    }

    public final boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (!(arg0 instanceof WeekDay)) {
            return false;
        }
        WeekDay wd = (WeekDay)arg0;
        return ObjectUtils.equals(wd.getDay(), this.getDay()) && wd.getOffset() == this.getOffset();
    }

    public final int hashCode() {
        return new HashCodeBuilder().append(this.getDay()).append(this.getOffset()).toHashCode();
    }
}

