/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.nlp;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.ocpsoft.prettytime.nlp.parse.DateGroup;
import org.ocpsoft.prettytime.shade.com.joestelmach.natty.Parser;

public class PrettyTimeParser {
    private Parser parser = new Parser();
    private Map<String, String> translations = new HashMap<String, String>();
    private Set<String> periods = new HashSet<String>();

    public PrettyTimeParser(TimeZone timezone) {
        this.parser = new Parser(timezone);
    }

    public PrettyTimeParser() {
        this(TimeZone.getDefault());
        this.translations.put("zero", "0");
        this.translations.put("one", "1");
        this.translations.put("two", "2");
        this.translations.put("three", "3");
        this.translations.put("four", "4");
        this.translations.put("five", "5");
        this.translations.put("six", "6");
        this.translations.put("seven", "7");
        this.translations.put("eight", "8");
        this.translations.put("nine", "9");
        this.translations.put("ten", "10");
        this.translations.put("eleven", "11");
        this.translations.put("twelve", "12");
        this.translations.put("thirteen", "13");
        this.translations.put("fourteen", "14");
        this.translations.put("fifteen", "15");
        this.translations.put("sixteen", "16");
        this.translations.put("seventeen", "17");
        this.translations.put("eighteen", "18");
        this.translations.put("nineteen", "19");
        this.translations.put("twenty", "20");
        this.translations.put("thirty", "30");
        this.translations.put("fourty", "40");
        this.translations.put("fifty", "50");
        this.translations.put("sixty", "60");
        this.translations.put("seventy", "70");
        this.translations.put("eighty", "80");
        this.translations.put("ninety", "90");
        this.periods.add("morning");
        this.periods.add("afternooon");
        this.periods.add("evening");
        this.periods.add("night");
        this.periods.add("am");
        this.periods.add("pm");
        this.periods.add("ago");
        this.periods.add("from now");
    }

    public List<Date> parse(String language) {
        language = this.words2numbers(language);
        ArrayList<Date> result = new ArrayList<Date>();
        List<org.ocpsoft.prettytime.shade.com.joestelmach.natty.DateGroup> groups = this.parser.parse(language);
        for (org.ocpsoft.prettytime.shade.com.joestelmach.natty.DateGroup group : groups) {
            List<Date> dates = this.relativize(group);
            result.addAll(dates);
        }
        return result;
    }

    public List<DateGroup> parseSyntax(String language) {
        language = this.words2numbers(language);
        ArrayList<DateGroup> result = new ArrayList<DateGroup>();
        List<org.ocpsoft.prettytime.shade.com.joestelmach.natty.DateGroup> groups = this.parser.parse(language);
        Date now = new Date();
        for (org.ocpsoft.prettytime.shade.com.joestelmach.natty.DateGroup group : groups) {
            result.add(new DateGroupImpl(now, group));
        }
        return result;
    }

    private String words2numbers(String language) {
        for (Map.Entry<String, String> entry : this.translations.entrySet()) {
            language = language.replaceAll("\\b" + entry.getKey() + "\\b", entry.getValue());
        }
        return language;
    }

    private List<Date> relativize(org.ocpsoft.prettytime.shade.com.joestelmach.natty.DateGroup group) {
        String matchingValue = group.getText();
        boolean ambiguous = true;
        for (String qualifier : this.periods) {
            if (!matchingValue.contains(qualifier)) continue;
            ambiguous = false;
        }
        List<Date> result = group.getDates();
        if (ambiguous) {
            Date now = new Date();
            for (int i = 0; i < result.size(); ++i) {
                Date date = result.get(i);
                while (date.before(now)) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    calendar.add(11, 12);
                    date = calendar.getTime();
                    result.set(i, date);
                }
            }
        }
        return result;
    }

    private class DateGroupImpl
    implements DateGroup {
        private List<Date> dates;
        private int line;
        private int position;
        private Date recursUntil;
        private String text;
        private boolean recurring;
        private Date now;

        public DateGroupImpl(Date now, org.ocpsoft.prettytime.shade.com.joestelmach.natty.DateGroup group) {
            this.now = now;
            this.dates = group.getDates();
            this.line = group.getLine();
            this.position = group.getPosition();
            this.recursUntil = group.getRecursUntil();
            this.text = group.getText();
            this.recurring = group.isRecurring();
        }

        @Override
        public List<Date> getDates() {
            return this.dates;
        }

        @Override
        public int getLine() {
            return this.line;
        }

        @Override
        public int getPosition() {
            return this.position;
        }

        @Override
        public Date getRecursUntil() {
            return this.recursUntil;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public boolean isRecurring() {
            return this.recurring;
        }

        @Override
        public long getRecurInterval() {
            if (this.isRecurring()) {
                return this.getDates().get(0).getTime() - this.now.getTime();
            }
            return -1L;
        }
    }
}

