/*
 * Decompiled with CFR 0.152.
 */
package org.objenesis.tck.search;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassEnumerator {
    private static void processDirectory(File directory, String pkgname, SortedSet<String> classes) {
        String[] files = directory.list();
        for (int i = 0; i < files.length; ++i) {
            String fileName = files[i];
            if (fileName.endsWith(".class")) {
                String className = pkgname + '.' + fileName.substring(0, fileName.length() - 6);
                classes.add(className);
                continue;
            }
            File subdir = new File(directory, fileName);
            if (!subdir.isDirectory()) continue;
            ClassEnumerator.processDirectory(subdir, pkgname + '.' + fileName, classes);
        }
    }

    private static void processJarfile(URL resource, String pkgname, SortedSet<String> classes) {
        JarFile jarFile;
        String relPath = pkgname.replace('.', '/');
        String resPath = resource.getPath();
        String jarPath = resPath.replaceFirst("[.]jar[!].*", ".jar").replaceFirst("file:", "");
        try {
            jarFile = new JarFile(jarPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException reading JAR File '" + jarPath + "'", e);
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            String className = null;
            if (entryName.endsWith(".class") && entryName.startsWith(relPath) && entryName.length() > relPath.length() + "/".length()) {
                className = entryName.replace('/', '.').replace('\\', '.').replace(".class", "");
            }
            if (className == null) continue;
            classes.add(className);
        }
    }

    public static SortedSet<String> getClassesForPackage(Package pkg) {
        return ClassEnumerator.getClassesForPackage(pkg, ClassEnumerator.class.getClassLoader());
    }

    public static SortedSet<String> getClassesForPackage(Package pkg, ClassLoader classLoader) {
        Enumeration<URL> resources;
        TreeSet<String> classes = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String simpleName1 = this.getSimpleName(o1);
                String simpleName2 = this.getSimpleName(o2);
                return simpleName1.compareTo(simpleName2);
            }

            private String getSimpleName(String className) {
                return className.substring(className.lastIndexOf(46));
            }
        });
        String pkgname = pkg.getName();
        String relPath = pkgname.replace('.', '/');
        try {
            resources = classLoader.getResources(relPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            if (resource.toString().startsWith("jar:")) {
                ClassEnumerator.processJarfile(resource, pkgname, classes);
                continue;
            }
            ClassEnumerator.processDirectory(new File(resource.getPath()), pkgname, classes);
        }
        return classes;
    }
}

