/*
 * Decompiled with CFR 0.152.
 */
package org.objenesis.tck;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objenesis.Objenesis;
import org.objenesis.strategy.PlatformDescription;
import org.objenesis.tck.Reporter;

public class TCK {
    private final List objenesisInstances = new ArrayList();
    private final List candidates = new ArrayList();
    private final Map descriptions = new HashMap();

    public void registerCandidate(Class candidateClass, String description) {
        this.candidates.add(candidateClass);
        this.descriptions.put(candidateClass, description);
    }

    public void registerObjenesisInstance(Objenesis objenesis, String description) {
        this.objenesisInstances.add(objenesis);
        this.descriptions.put(objenesis, description);
    }

    public void runTests(Reporter reporter) {
        reporter.startTests(this.describePlatform(), this.findAllDescriptions(this.candidates, this.descriptions), this.findAllDescriptions(this.objenesisInstances, this.descriptions));
        Iterator i = this.candidates.iterator();
        while (i.hasNext()) {
            Class candidateClass = (Class)i.next();
            String candidateDescription = (String)this.descriptions.get(candidateClass);
            Iterator j = this.objenesisInstances.iterator();
            while (j.hasNext()) {
                Objenesis objenesis = (Objenesis)j.next();
                String objenesisDescription = (String)this.descriptions.get(objenesis);
                reporter.startTest(candidateDescription, objenesisDescription);
                this.runTest(reporter, candidateClass, objenesis, candidateDescription);
                reporter.endTest();
            }
        }
        reporter.endTests();
    }

    private void runTest(Reporter reporter, Class candidate, Objenesis objenesis, String candidateDescription) {
        try {
            Object instance = objenesis.newInstance(candidate);
            boolean success = instance != null && instance.getClass() == candidate;
            reporter.result(success);
        }
        catch (Exception e) {
            reporter.exception(e);
        }
    }

    private Collection findAllDescriptions(List keys, Map descriptions) {
        ArrayList results = new ArrayList(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            results.add(descriptions.get(keys.get(i)));
        }
        return results;
    }

    protected String describePlatform() {
        return "Java " + PlatformDescription.SPECIFICATION_VERSION + " (" + "vendor=\"" + PlatformDescription.VENDOR + "\", " + "vendor version=" + PlatformDescription.VENDOR_VERSION + ", " + "JVM name=\"" + PlatformDescription.JVM_NAME + "\", " + "JVM version=" + PlatformDescription.VM_VERSION + ", " + "JVM info=" + PlatformDescription.VM_VERSION + ")";
    }
}

