/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jonas.discovery.internal.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.objectweb.jonas.discovery.internal.comm.message.DiscEvent;
import org.objectweb.jonas.discovery.internal.comm.message.DiscGreeting;
import org.objectweb.jonas.discovery.internal.comm.message.DiscMessage;

public class DiscoveryHelper {
    private static int DISC_MESSAGE = 0;
    private static int DISC_EVENT = 1;
    private static int DISC_GREETING = 2;
    private static int RECEIVE_BUFFER_SIZE = 1024;

    public static byte[] objectToBytes(Object obj) throws IOException {
        byte[] resultBytes = null;
        if (!(obj instanceof DiscMessage)) {
            return null;
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream stream = new ObjectOutputStream(byteStream);
        try {
            if (obj instanceof DiscEvent) {
                stream.writeInt(DISC_EVENT);
            } else if (obj instanceof DiscGreeting) {
                stream.writeInt(DISC_GREETING);
            } else {
                stream.writeInt(DISC_MESSAGE);
            }
            stream.writeObject(obj);
            resultBytes = byteStream.toByteArray();
            byteStream.close();
            stream.close();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            byteStream.close();
            stream.close();
        }
        return resultBytes;
    }

    public static Object bytesToObject(byte[] bytes) throws IOException, ClassNotFoundException {
        DiscMessage resultObject = null;
        ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
        ObjectInputStream stream = new ObjectInputStream(byteStream);
        try {
            int type = stream.readInt();
            if (type == DISC_MESSAGE) {
                resultObject = (DiscMessage)stream.readObject();
            } else if (type == DISC_EVENT) {
                resultObject = (DiscEvent)stream.readObject();
            } else if (type == DISC_GREETING) {
                resultObject = (DiscGreeting)stream.readObject();
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        finally {
            byteStream.close();
            stream.close();
        }
        return resultObject;
    }

    private void sendDiscoveryMessage(DiscMessage msg, DatagramSocket socket, InetAddress destAddress, int destPort) throws IOException {
        byte[] messageBytes = DiscoveryHelper.objectToBytes(msg);
        DatagramPacket packet = new DatagramPacket(messageBytes, messageBytes.length, destAddress, destPort);
        this.sendPacket(socket, packet);
    }

    private DiscMessage receiveDiscoveryMessage(DatagramSocket socket) throws IOException, ClassNotFoundException {
        DatagramPacket packet = new DatagramPacket(new byte[RECEIVE_BUFFER_SIZE], RECEIVE_BUFFER_SIZE);
        this.receivePacket(socket, packet);
        return (DiscMessage)DiscoveryHelper.bytesToObject(packet.getData());
    }

    private void sendPacket(DatagramSocket socket, DatagramPacket packet) throws IOException {
        socket.send(packet);
    }

    private void receivePacket(DatagramSocket socket, DatagramPacket packet) throws IOException {
        socket.receive(packet);
    }
}

