/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jonas.discovery.internal.enroller;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.objectweb.jonas.common.Log;
import org.objectweb.jonas.discovery.DiscoveryEvent;
import org.objectweb.jonas.discovery.internal.comm.message.DiscEvent;
import org.objectweb.jonas.discovery.internal.enroller.Enroller;
import org.objectweb.jonas.discovery.internal.utils.DiscoveryHelper;
import org.objectweb.jonas.management.monitoring.DomainMonitor;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class DiscoveryListener
implements Runnable {
    public static final String DISCOVERY_TYPE = "jonas.management.discovery";
    private static int RECEIVE_BUFFER_SIZE = 1024;
    private int port;
    private InetAddress groupAddress;
    private int ttl = 1;
    private MulticastSocket multicastSocket;
    private boolean notStopped = true;
    private static Logger logger = Log.getLogger((String)"org.objectweb.jonas.discovery");

    public DiscoveryListener(Enroller enroller) {
        this.port = enroller.getListeningPort();
        try {
            this.groupAddress = InetAddress.getByName(enroller.getListeningIp());
            this.ttl = enroller.getTimeToLive();
        }
        catch (UnknownHostException e) {
            logger.log(BasicLevel.ERROR, (Object)e);
        }
    }

    private void join() {
        try {
            this.multicastSocket = new MulticastSocket(this.port);
            this.multicastSocket.setTimeToLive(this.ttl);
            this.multicastSocket.joinGroup(this.groupAddress);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("multicast ip address is " + this.groupAddress));
                logger.log(BasicLevel.DEBUG, (Object)("multicast port is " + this.port));
            }
        }
        catch (IOException e) {
            logger.log(BasicLevel.ERROR, (Object)"io problem");
            e.printStackTrace();
        }
    }

    private DatagramPacket getDatagram(int length) {
        return new DatagramPacket(new byte[length], length);
    }

    public void run() {
        this.join();
        try {
            while (this.notStopped) {
                DatagramPacket datagram = this.getDatagram(RECEIVE_BUFFER_SIZE);
                this.multicastSocket.receive(datagram);
                Object objReceived = DiscoveryHelper.bytesToObject(datagram.getData());
                if (objReceived != null && objReceived instanceof DiscEvent) {
                    DiscEvent event = (DiscEvent)objReceived;
                    event.setSourceAddress(datagram.getAddress().getHostAddress());
                    DomainMonitor dm = DomainMonitor.getInstance();
                    if (dm == null) {
                        logger.log(BasicLevel.WARN, (Object)"No DomainMonitor");
                    } else {
                        dm.discoveryNotification((DiscoveryEvent)event);
                    }
                }
                datagram = null;
            }
        }
        catch (SocketException e) {
            logger.log(BasicLevel.ERROR, (Object)("Enroller: Socket closed" + e));
            this.notStopped = false;
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void stopListener() {
        this.notStopped = false;
    }
}

