/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jonas.discovery.internal.comm;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import org.objectweb.jonas.common.Log;
import org.objectweb.jonas.discovery.internal.comm.DiscoveryGreetingResponder;
import org.objectweb.jonas.discovery.internal.comm.message.DiscGreeting;
import org.objectweb.jonas.discovery.internal.manager.DiscoveryManager;
import org.objectweb.jonas.discovery.internal.utils.DiscoveryHelper;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class DiscoveryGreetingListener
extends DiscoveryGreetingResponder {
    private static Logger logger = Log.getLogger((String)"org.objectweb.jonas.discovery");
    private int mesgsSameServerIDCount = 0;

    public DiscoveryGreetingListener(DiscoveryManager dm) {
        super(dm);
    }

    public void run() {
        this.mesgsSameServerIDCount = 0;
        this.join();
        try {
            this.unicastSocket = new DatagramSocket();
        }
        catch (SocketException e3) {
            logger.log(BasicLevel.ERROR, (Object)"Socket exception", (Throwable)e3);
            return;
        }
        try {
            while (this.notStopped) {
                DatagramPacket datagram = this.getDatagram(1024);
                this.multicastSocket.receive(datagram);
                Object objReceived = DiscoveryHelper.bytesToObject(datagram.getData());
                if (objReceived != null && objReceived instanceof DiscGreeting) {
                    DiscGreeting request = (DiscGreeting)objReceived;
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)("DiscGreeting received on multicast:\n" + request));
                    }
                    if (request != null && request.getServerId().equals(this.serverId) && request.getDomainName().equals(this.domainName)) {
                        ++this.mesgsSameServerIDCount;
                        if (this.mesgsSameServerIDCount > 1) {
                            InetAddress destAddress = datagram.getAddress();
                            int destPort = request.getSourcePort();
                            DiscGreeting msg = this.createDiscGreeting(false);
                            this.sendResponse(msg, destAddress, destPort);
                        }
                    }
                }
                datagram = null;
            }
        }
        catch (SocketException e) {
            logger.log(BasicLevel.ERROR, (Object)"Socket closed: ", (Throwable)e);
            this.notStopped = false;
        }
        catch (IOException e1) {
            logger.log(BasicLevel.ERROR, (Object)e1);
        }
        catch (ClassNotFoundException e) {
            logger.log(BasicLevel.ERROR, (Object)e);
        }
    }

    public void stop() {
        Thread.interrupted();
    }
}

