/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jonas.discovery.internal.comm;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.objectweb.jonas.common.Log;
import org.objectweb.jonas.common.NetUtils;
import org.objectweb.jonas.discovery.internal.comm.message.DiscEvent;
import org.objectweb.jonas.discovery.internal.comm.message.DiscGreeting;
import org.objectweb.jonas.discovery.internal.comm.message.DiscMessage;
import org.objectweb.jonas.discovery.internal.manager.DiscoveryManager;
import org.objectweb.jonas.discovery.internal.utils.DiscoveryHelper;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class DiscoveryComm
implements Runnable {
    public static final int RECEIVE_BUFFER_SIZE = 1024;
    protected MulticastSocket multicastSocket;
    protected DatagramSocket unicastSocket;
    private int port;
    private InetAddress destAddress;
    protected boolean notStopped = true;
    private int ttl = 1;
    protected String jonasName = null;
    protected String domainName = null;
    protected String serverId = null;
    protected String[] urls = null;
    private static Logger logger = Log.getLogger((String)"org.objectweb.jonas.discovery");

    public DiscoveryComm(DiscoveryManager dm) {
        this.port = dm.getListeningPort();
        try {
            this.destAddress = InetAddress.getByName(dm.getListeningIp());
            this.ttl = dm.getTimeToLive();
            this.jonasName = dm.getJonasName();
            this.domainName = dm.getDomainName();
            this.urls = dm.getUrls();
            this.serverId = dm.getServerId();
        }
        catch (UnknownHostException e) {
            logger.log(BasicLevel.ERROR, (Object)"Unknown Host", (Throwable)e);
        }
    }

    protected void join() {
        try {
            this.multicastSocket = new MulticastSocket(this.port);
            this.multicastSocket.setTimeToLive(this.ttl);
            this.multicastSocket.joinGroup(this.destAddress);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("multicast ip address is " + this.destAddress));
                logger.log(BasicLevel.DEBUG, (Object)("multicast port is " + this.port));
            }
        }
        catch (IOException e) {
            logger.log(BasicLevel.ERROR, (Object)"io problem", (Throwable)e);
        }
    }

    public void sendNotif(DiscMessage msg) {
        try {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)msg);
            }
            byte[] messageBytes = DiscoveryHelper.objectToBytes(msg);
            this.multicastSocket.send(new DatagramPacket(messageBytes, messageBytes.length, this.destAddress, this.port));
        }
        catch (IOException e1) {
            logger.log(BasicLevel.ERROR, (Object)"DiscoveryComm: Error to send notification", (Throwable)e1);
        }
    }

    protected void sendResponse(DiscMessage msg, InetAddress destAddress, int port) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("DiscoveryComm : The message to send is " + msg + "Sending it to: " + destAddress + " and port is: " + port));
        }
        try {
            byte[] messageBytes = DiscoveryHelper.objectToBytes(msg);
            if (messageBytes != null) {
                this.unicastSocket.send(new DatagramPacket(messageBytes, messageBytes.length, destAddress, port));
            }
        }
        catch (IOException e) {
            logger.log(BasicLevel.ERROR, (Object)"DiscoveryComm: Error to send response to discovery message", (Throwable)e);
        }
    }

    public DiscEvent createNotifMessage(String state) throws Exception {
        String theHostAddress;
        try {
            theHostAddress = NetUtils.getLocalAddress();
        }
        catch (UnknownHostException e) {
            logger.log(BasicLevel.ERROR, (Object)"Unknown host", (Throwable)e);
            return null;
        }
        if (!state.equals("running")) {
            this.urls = null;
        }
        DiscEvent resp = new DiscEvent(theHostAddress, this.port, this.jonasName, this.domainName, this.serverId, this.urls);
        resp.setState(state);
        return resp;
    }

    protected DatagramPacket getDatagram(int length) {
        return new DatagramPacket(new byte[length], length);
    }

    public void run() {
        this.join();
        DiscEvent discEventMsg = null;
        try {
            discEventMsg = this.createNotifMessage("running");
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)"DiscoveryComm:  Unable to create a notification message", (Throwable)e);
        }
        if (discEventMsg != null) {
            this.sendNotif(discEventMsg);
        }
        try {
            this.unicastSocket = new DatagramSocket();
        }
        catch (SocketException e3) {
            logger.log(BasicLevel.ERROR, (Object)"Socket exception", (Throwable)e3);
            return;
        }
        try {
            while (this.notStopped) {
                DatagramPacket datagram = this.getDatagram(1024);
                this.multicastSocket.receive(datagram);
                Object objReceived = DiscoveryHelper.bytesToObject(datagram.getData());
                if (objReceived != null) {
                    if (objReceived instanceof DiscEvent || objReceived instanceof DiscGreeting) {
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("This discovery event/greeting is ignored " + objReceived));
                        }
                    } else {
                        DiscMessage request = (DiscMessage)objReceived;
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("A discovery message is received " + objReceived));
                        }
                        if (discEventMsg != null) {
                            InetAddress destAddress = datagram.getAddress();
                            int destPort = request.getSourcePort();
                            this.sendResponse(discEventMsg, destAddress, destPort);
                        }
                    }
                }
                datagram = null;
            }
        }
        catch (SocketException e) {
            logger.log(BasicLevel.ERROR, (Object)"Socket closed: ", (Throwable)e);
            this.notStopped = false;
        }
        catch (IOException e1) {
            logger.log(BasicLevel.ERROR, (Object)e1);
        }
        catch (ClassNotFoundException e) {
            logger.log(BasicLevel.ERROR, (Object)e);
        }
    }

    public void stop() {
        DiscEvent msg = null;
        try {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"Sending a STOPPING DiscEvent.");
            }
            msg = this.createNotifMessage("stopping");
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)e);
        }
        if (msg != null) {
            this.sendNotif(msg);
        }
        Thread.interrupted();
    }

    protected void setJonasName(String jonasName) {
        this.jonasName = jonasName;
    }

    protected void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    protected void setUrls(String[] urls) {
        this.urls = urls;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }
}

