/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jonas.discovery.internal.client;

import java.net.UnknownHostException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.objectweb.jonas.common.Log;
import org.objectweb.jonas.common.NetUtils;
import org.objectweb.jonas.discovery.internal.client.DiscoveryClientListener;
import org.objectweb.jonas.discovery.internal.client.DiscoveryClientMBean;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class DiscoveryClient
implements DiscoveryClientMBean,
MBeanRegistration {
    private int sourcePort;
    private String sourceIp;
    private ObjectName myOn;
    private DiscoveryClientListener dcl = null;
    private Thread discoveryClientListener = null;
    private int ttl = 1;
    private int timeout = 1000;
    private int listeningPort;
    private String listeningIp;
    private static Logger logger = Log.getLogger((String)"org.objectweb.jonas.discovery");

    public DiscoveryClient(int listeningPort, String listeningIP, int sourcePort) {
        this.listeningIp = listeningIP;
        this.listeningPort = listeningPort;
        this.sourcePort = sourcePort;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getListeningPort() {
        return this.listeningPort;
    }

    public void setListeningPort(int listeningPort) {
        this.listeningPort = listeningPort;
    }

    public String getListeningIp() {
        return this.listeningIp;
    }

    public void setListeningIp(String ipAddress) {
        this.listeningIp = ipAddress;
    }

    public int getSourcePort() {
        return this.sourcePort;
    }

    public void setSourcePort(int sourcePort) {
        this.sourcePort = sourcePort;
    }

    public String getSourceIp() {
        return this.sourceIp;
    }

    public int getTimeToLive() {
        return this.ttl;
    }

    public void setSourceIp(String sourceIp) {
        this.sourceIp = sourceIp;
    }

    public void setTimeToLive(int ttl) {
        this.ttl = ttl;
    }

    public void start() {
        try {
            this.setSourceIp(NetUtils.getLocalAddress());
        }
        catch (UnknownHostException e) {
            logger.log(BasicLevel.ERROR, (Object)"Unable to create a localhost.", (Throwable)e);
        }
        this.dcl = new DiscoveryClientListener(this);
        if (this.discoveryClientListener == null) {
            this.discoveryClientListener = new Thread((Runnable)this.dcl, "discoveryClientListener");
        }
        this.discoveryClientListener.start();
    }

    public void stop() {
    }

    public ObjectName preRegister(MBeanServer mbeanServer, ObjectName on) {
        this.myOn = on;
        return this.myOn;
    }

    public void postRegister(Boolean arg0) {
        this.start();
    }

    public void preDeregister() throws Exception {
        this.dcl.stop();
    }

    public void postDeregister() {
    }
}

