/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jonas.discovery.internal;

import java.util.ArrayList;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.remote.JMXServiceURL;
import javax.naming.Context;
import javax.naming.NamingException;
import org.objectweb.jonas.common.Log;
import org.objectweb.jonas.discovery.DiscoveryService;
import org.objectweb.jonas.discovery.internal.DiscoveryServiceImplMBean;
import org.objectweb.jonas.discovery.internal.DuplicateServerNameException;
import org.objectweb.jonas.discovery.internal.client.DiscoveryClient;
import org.objectweb.jonas.discovery.internal.comm.message.DiscEvent;
import org.objectweb.jonas.discovery.internal.enroller.Enroller;
import org.objectweb.jonas.discovery.internal.manager.DiscoveryManager;
import org.objectweb.jonas.jmx.JmxService;
import org.objectweb.jonas.jmx.oname.JonasObjectName;
import org.objectweb.jonas.service.AbsServiceImpl;
import org.objectweb.jonas.service.ServiceException;
import org.objectweb.jonas.service.manager.ServiceManager;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class DiscoveryServiceImpl
extends AbsServiceImpl
implements DiscoveryService,
DiscoveryServiceImplMBean {
    private static final String DISCOVERY_SOURCE_PORT_DEFAULT = "9888";
    private static final String DISCOVERY_GREETING_PORT_DEFAULT = "9899";
    private static final String DISCOVERY_GREETING_TIMEOUT_DEFAULT = "1000";
    private String listeningIp = null;
    private int listeningPort;
    private int greetingListeningPort;
    private int greetingAckTimeOut;
    private int sourcePort;
    private static final int DISCOVERY_TTL_DEFAULT = 1;
    private int ttl = 1;
    private boolean isDiscoveryMaster = false;
    private JmxService jmxService = null;
    private static Logger logger = null;

    public String getMulticastAddress() {
        return this.listeningIp;
    }

    public String getMulticastPort() {
        return String.valueOf(this.listeningPort);
    }

    public Boolean getIsDiscoveryMaster() {
        return new Boolean(this.isDiscoveryMaster);
    }

    public void startDiscoveryMaster() throws JMException {
        if (!this.isDiscoveryMaster) {
            this.createEnroller(this.getDomainName());
            this.createDiscClient(this.getDomainName());
            this.isDiscoveryMaster = true;
        }
    }

    protected void doInit(Context ctx) throws ServiceException {
        logger = Log.getLogger((String)"org.objectweb.jonas.discovery");
        try {
            this.listeningIp = (String)ctx.lookup("jonas.service.discovery.multicast.address");
            String sListeningPort = (String)ctx.lookup("jonas.service.discovery.multicast.port");
            this.listeningPort = Integer.valueOf(sListeningPort);
        }
        catch (NamingException ne) {
            String err = "Cannot read initializations arguments in service context";
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new ServiceException(err, (Throwable)ne);
        }
        try {
            String sttl = (String)ctx.lookup("jonas.service.discovery.ttl");
            if (sttl != null) {
                this.ttl = Integer.valueOf(sttl);
                logger.log(BasicLevel.DEBUG, (Object)("discovery TTL set to " + this.ttl));
            }
        }
        catch (NamingException ne) {
            // empty catch block
        }
        try {
            String sMaster = (String)ctx.lookup("jonas.service.discovery.master");
            if (sMaster != null && sMaster.equals("true")) {
                this.isDiscoveryMaster = true;
            }
        }
        catch (NamingException ne) {
            // empty catch block
        }
        String sSourcePort = null;
        String greetListeningPort = null;
        String greetAckTimeOut = null;
        try {
            sSourcePort = (String)ctx.lookup("jonas.service.discovery.source.port");
        }
        catch (NamingException ne) {
            sSourcePort = DISCOVERY_SOURCE_PORT_DEFAULT;
        }
        this.sourcePort = Integer.valueOf(sSourcePort);
        try {
            greetListeningPort = (String)ctx.lookup("jonas.service.discovery.greeting.port");
        }
        catch (NamingException e1) {
            greetListeningPort = DISCOVERY_GREETING_PORT_DEFAULT;
        }
        this.greetingListeningPort = Integer.valueOf(greetListeningPort);
        try {
            greetAckTimeOut = (String)ctx.lookup("jonas.service.discovery.greeting.timeout");
        }
        catch (NamingException e1) {
            greetAckTimeOut = DISCOVERY_GREETING_TIMEOUT_DEFAULT;
        }
        this.greetingAckTimeOut = Integer.valueOf(greetAckTimeOut);
        ServiceManager sm = null;
        try {
            sm = ServiceManager.getInstance();
        }
        catch (Exception e) {
            String err = "Cannot get ServiceManager instance";
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new ServiceException(err, (Throwable)e);
        }
        this.jmxService = (JmxService)sm.getJmxService();
    }

    protected void doStart() throws ServiceException {
        DiscoveryManager dm = new DiscoveryManager(this.getJonasServerName(), this.listeningPort, this.listeningIp, this.greetingListeningPort, this.greetingAckTimeOut);
        String domainName = this.getDomainName();
        dm.setDomainName(domainName);
        dm.setJonasName(this.jmxService.getJonasServerName());
        dm.setTimeToLive(this.ttl);
        JMXServiceURL[] connectorServerURLs = this.jmxService.getConnectorServerURLs();
        ArrayList<String> urlsList = new ArrayList<String>();
        for (int i = 0; i < connectorServerURLs.length; ++i) {
            if (connectorServerURLs[i] == null) continue;
            urlsList.add(connectorServerURLs[i].toString());
        }
        String[] urls = new String[urlsList.size()];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = (String)urlsList.get(i);
        }
        dm.setUrls(urls);
        try {
            this.jmxService.registerMBean((Object)dm, JonasObjectName.discoveryManager((String)domainName));
        }
        catch (MalformedObjectNameException e1) {
            e1.printStackTrace();
            throw new ServiceException("Problem when starting the Discovery Service:", (Throwable)e1);
        }
        try {
            dm.start();
        }
        catch (DuplicateServerNameException e) {
            logger.log(BasicLevel.ERROR, (Object)"Discovery manager failed to start due to a pre-existing server in the domain with the same name.", (Throwable)((Object)e));
            try {
                this.jmxService.unregisterMBean(JonasObjectName.discoveryManager((String)domainName));
            }
            catch (MalformedObjectNameException e1) {
                e1.printStackTrace();
                throw new ServiceException("Problem when starting the Discovery Service:", (Throwable)e1);
            }
            throw new ServiceException("Problem when starting the Discovery Service:", (Throwable)((Object)e));
        }
        if (this.isDiscoveryMaster) {
            try {
                this.createEnroller(domainName);
            }
            catch (JMException e) {
                throw new ServiceException("Problem when starting the Discovery Service: ", (Throwable)e);
            }
            try {
                this.createDiscClient(domainName);
            }
            catch (JMException e) {
                throw new ServiceException("Problem when starting the Discovery Service: ", (Throwable)e);
            }
        }
        this.jmxService.registerMBean((Object)this, JonasObjectName.discoveryService((String)domainName));
    }

    private void createEnroller(String domainName) throws JMException {
        Enroller enroller = new Enroller(this.listeningPort, this.listeningIp);
        enroller.setTimeToLive(this.ttl);
        this.jmxService.registerMBean((Object)enroller, JonasObjectName.discoveryEnroller((String)domainName));
    }

    private void createDiscClient(String domainName) throws JMException {
        DiscoveryClient dc = new DiscoveryClient(this.listeningPort, this.listeningIp, this.sourcePort);
        dc.setTimeToLive(this.ttl);
        this.jmxService.registerMBean((Object)dc, JonasObjectName.discoveryClient((String)domainName));
    }

    protected void doStop() throws ServiceException {
        this.jmxService.unregisterMBean(JonasObjectName.discoveryService((String)this.getDomainName()));
    }

    public DiscEvent getDiscEvent(String serverName, String domainName, String[] connectorURLs, String state) {
        String sourceAddress = null;
        int sourcePort = 0;
        String serverId = null;
        DiscEvent fakeMessage = new DiscEvent(sourceAddress, sourcePort, serverName, domainName, serverId, connectorURLs);
        fakeMessage.setState(state);
        return fakeMessage;
    }

    public String getDiscoveryProtocolVersion() {
        return "1.1";
    }

    public String getDiscoveryTtl() {
        return new Integer(this.ttl).toString();
    }
}

