/**
* JOnAS: Java(TM) Open Application Server
* Copyright (C) 2004 Bull S.A.
* Contact: jonas-team@objectweb.org
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
* USA
*
* --------------------------------------------------------------------------
* $Id: DiscoveryServiceImplMBean.java 10761 2007-06-27 08:38:39Z danesa $
* --------------------------------------------------------------------------
*/

package org.objectweb.jonas.discovery.internal;

import javax.management.JMException;

/**
 * Management interface for the discovery service
 * @author Adriana Danes
 *
 */
public interface DiscoveryServiceImplMBean {
    /**
     * @return the multicast group IP address used by the discovery service
     */
    String getMulticastAddress();
    /**
     * @return the multicast group port number used by the discovery service
     */
    String getMulticastPort();
    /**
     * @return true if the current server is a discovery master
     */
    Boolean getIsDiscoveryMaster();
    /**
     * @return the discovery protocol version number
     */
    String getDiscoveryProtocolVersion();
    /**
     * @return the time-to-live of the discovery multicast
     */
    String getDiscoveryTtl();
    /**
     * Make this server a discovery master.
     * @throws JMException a JMX exception occured when trying to make current server a discovery master
     */
    void startDiscoveryMaster() throws JMException;
}