/*==============================================================================
 The Fraclet Programming Model - Fractal Component Model (fractal@objectweb.org)
 Copyright (C) 2002-2006 INRIA Futurs / LIFL
 Copyright (C) 2006-2007 Universitetet i Oslo

 This library is free software; you can redistribute it and/or modify it under 
 the terms of the GNU Lesser General Public License as published by the Free 
 Software Foundation; either version 2.1 of the License, or any later version.

 This library is distributed in the hope that it will be useful, but WITHOUT ANY 
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public License along 
 with this library; if not, write to the Free Software Foundation, Inc., 
 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

 Initial developer(s): Romain Rouvoy
 Contributor(s): 
 =============================================================================*/
package org.objectweb.fractal.spoonlet.binding;

import java.util.List;

import org.objectweb.fractal.api.NoSuchInterfaceException;

import spoon.template.Local;

/**
 * A template to introduce the binding controller method signature by overriding
 * parent's ones.
 * 
 * @author Romain Rouvoy (Initial Developer)
 * @version $Revision$
 */
@Local
public class BindingExtensionTemplate extends BindingControllerTemplate {
    // ***************************** TEMPLATE PART *****************************
    /**
     * Completes the list of bound interfaces.
     * 
     * @param set incomplete list of interface identifiers.
     */
    protected void listFc(List<String> set) {
        super.listFc(set);
    }

    /* (non-Javadoc)
     * @see org.objectweb.fractal.api.control.BindingController#lookupFc(java.lang.String)
     */
    @Override
    public Object lookupFc(String id) throws NoSuchInterfaceException {
        return super.lookupFc(id);
    }

    /* (non-Javadoc)
     * @see org.objectweb.fractal.api.control.BindingController#bindFc(java.lang.String,java.lang.Object)
     */
    @Override
    public void bindFc(String id, Object ref) throws NoSuchInterfaceException {
        super.bindFc(id, ref);
    }

    /* (non-Javadoc)
     * @see org.objectweb.fractal.api.control.BindingController#unbindFc(java.lang.String)
     */
    @Override
    public void unbindFc(String id) throws NoSuchInterfaceException {
        super.unbindFc(id);
    }
}