/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.eggg.GenericResolver;
import org.noear.solon.core.util.EgggUtil;

public class GenericUtil {
    private static final Map<Type, Map<String, Type>> genericInfoCached = new ConcurrentHashMap<Type, Map<String, Type>>();

    @Deprecated
    public static Class<?>[] resolveTypeArguments(Class<?> clazz, Class<?> genericIfc) {
        ArrayList<Class> types = new ArrayList<Class>();
        for (Type type : EgggUtil.findGenericList(clazz, genericIfc)) {
            if (!(type instanceof Class)) continue;
            types.add((Class)type);
        }
        return types.toArray(new Class[types.size()]);
    }

    @Deprecated
    public static ParameterizedType toParameterizedType(Type type) throws RuntimeException {
        return GenericUtil.toParameterizedType(type, null);
    }

    @Deprecated
    public static ParameterizedType toParameterizedType(Type type, Map<String, Type> genericInfo) throws RuntimeException {
        return GenericResolver.getDefault().toParameterizedType(type, genericInfo);
    }

    public static Map<String, Type> getGenericInfo(Type type) {
        return genericInfoCached.computeIfAbsent(type, k -> GenericResolver.getDefault().createTypeDeepGenericMap(type));
    }

    @Deprecated
    public static Type reviewType(Type type, Type genericInfo) {
        if (type instanceof TypeVariable || type instanceof ParameterizedType) {
            return GenericUtil.reviewType(type, EgggUtil.getTypeEggg(genericInfo).getGenericInfo());
        }
        return type;
    }

    @Deprecated
    public static Type reviewType(Type type, Map<String, Type> genericInfo) {
        return GenericResolver.getDefault().reviewType(type, genericInfo);
    }

    @Deprecated
    public static boolean genericMatched(ParameterizedType checkType, ParameterizedType sourceType) {
        return GenericUtil.typeMatched(checkType, sourceType);
    }

    public static boolean typeMatched(Type checkType, Type sourceType) {
        if (checkType == sourceType) {
            return true;
        }
        if (checkType == null || sourceType == null) {
            return false;
        }
        if (checkType.equals(sourceType)) {
            return true;
        }
        return GenericUtil.dispatchTypeMatch(checkType, sourceType);
    }

    private static boolean dispatchTypeMatch(Type checkType, Type sourceType) {
        if (checkType instanceof ParameterizedType) {
            return GenericUtil.matchParameterizedType((ParameterizedType)checkType, sourceType);
        }
        if (checkType instanceof WildcardType) {
            return GenericUtil.matchWildcardType((WildcardType)checkType, sourceType);
        }
        if (checkType instanceof GenericArrayType) {
            return GenericUtil.matchGenericArrayType((GenericArrayType)checkType, sourceType);
        }
        return false;
    }

    private static boolean matchParameterizedType(ParameterizedType checkType, Type sourceType) {
        Type[] sourceArgs;
        if (!(sourceType instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType sourcePType = (ParameterizedType)sourceType;
        if (!GenericUtil.typeMatched(checkType.getRawType(), sourcePType.getRawType()) || !GenericUtil.matchOwnerType(checkType.getOwnerType(), sourcePType.getOwnerType())) {
            return false;
        }
        Type[] checkArgs = checkType.getActualTypeArguments();
        if (checkArgs.length != (sourceArgs = sourcePType.getActualTypeArguments()).length) {
            return false;
        }
        for (int i = 0; i < checkArgs.length; ++i) {
            if (GenericUtil.typeMatched(checkArgs[i], sourceArgs[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean matchOwnerType(Type owner1, Type owner2) {
        return owner1 == owner2 || owner1 != null && owner2 != null && GenericUtil.typeMatched(owner1, owner2);
    }

    private static boolean matchGenericArrayType(GenericArrayType checkArray, Type sourceType) {
        if (sourceType instanceof GenericArrayType) {
            GenericArrayType sourceArray = (GenericArrayType)sourceType;
            return GenericUtil.typeMatched(checkArray.getGenericComponentType(), sourceArray.getGenericComponentType());
        }
        if (sourceType instanceof Class) {
            return GenericUtil.matchGenericArrayToClass(checkArray, (Class)sourceType);
        }
        return false;
    }

    private static boolean matchGenericArrayToClass(GenericArrayType genericArray, Class<?> classArray) {
        if (!classArray.isArray()) {
            return false;
        }
        Type componentType = genericArray.getGenericComponentType();
        Class<?> arrayComponentType = classArray.getComponentType();
        Class<?> genericComponentClass = GenericUtil.extractRawClass(componentType);
        return genericComponentClass != null && arrayComponentType.isAssignableFrom(genericComponentClass);
    }

    private static boolean matchWildcardType(WildcardType wildcard, Type actualType) {
        if (actualType instanceof WildcardType) {
            return false;
        }
        if (actualType instanceof TypeVariable || actualType instanceof GenericArrayType) {
            return false;
        }
        Class<?> actualClass = GenericUtil.extractRawClass(actualType);
        if (actualClass != null) {
            return GenericUtil.matchWildcardToBounds(wildcard, actualClass);
        }
        return false;
    }

    private static boolean matchWildcardToBounds(WildcardType w1, Class<?> s1) {
        Class<?> boundClass;
        for (Type upperBound : w1.getUpperBounds()) {
            boundClass = GenericUtil.extractRawClass(upperBound);
            if (boundClass == null || boundClass.isAssignableFrom(s1)) continue;
            return false;
        }
        for (Type lowerBound : w1.getLowerBounds()) {
            boundClass = GenericUtil.extractRawClass(lowerBound);
            if (boundClass == null || s1.isAssignableFrom(boundClass)) continue;
            return false;
        }
        return true;
    }

    private static Class<?> extractRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            return rawType instanceof Class ? (Class)rawType : null;
        }
        if (type instanceof GenericArrayType) {
            return GenericUtil.extractArrayClass((GenericArrayType)type);
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            return upperBounds.length > 0 ? GenericUtil.extractRawClass(upperBounds[0]) : Object.class;
        }
        if (type instanceof TypeVariable) {
            Type[] bounds = ((TypeVariable)type).getBounds();
            return bounds.length > 0 ? GenericUtil.extractRawClass(bounds[0]) : Object.class;
        }
        return null;
    }

    private static Class<?> extractArrayClass(GenericArrayType arrayType) {
        Type componentType = arrayType.getGenericComponentType();
        Class<?> componentClass = GenericUtil.extractRawClass(componentType);
        if (componentClass != null) {
            try {
                return Array.newInstance(componentClass, 0).getClass();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Object[].class;
    }
}

