/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.route;

import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.route.PathRule;
import org.noear.solon.core.route.RouterInterceptor;
import org.noear.solon.core.route.RouterInterceptorChain;
import org.noear.solon.core.wrap.ParamWrap;

public class RouterInterceptorLimiter
implements RouterInterceptor {
    protected final PathRule rule;
    private final RouterInterceptor interceptor;

    public RouterInterceptorLimiter(RouterInterceptor interceptor, PathRule rule) {
        this.rule = rule;
        this.interceptor = interceptor;
    }

    protected boolean isMatched(Context ctx) {
        return this.rule == null || this.rule.isEmpty() || this.rule.test(ctx.pathNew());
    }

    public RouterInterceptor getInterceptor() {
        return this.interceptor;
    }

    @Override
    public PathRule pathPatterns() {
        return this.rule;
    }

    @Override
    public void doIntercept(Context ctx, Handler mainHandler, RouterInterceptorChain chain) throws Throwable {
        if (this.isMatched(ctx)) {
            this.interceptor.doIntercept(ctx, mainHandler, chain);
        } else {
            chain.doIntercept(ctx, mainHandler);
        }
    }

    @Override
    public void postArguments(Context ctx, ParamWrap[] args, Object[] vals) throws Throwable {
        if (this.isMatched(ctx)) {
            this.interceptor.postArguments(ctx, args, vals);
        }
    }

    @Override
    public Object postResult(Context ctx, Object result) throws Throwable {
        if (this.isMatched(ctx)) {
            return this.interceptor.postResult(ctx, result);
        }
        return result;
    }
}

