/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.DownloadedFile;
import org.noear.solon.core.handle.Entity;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.handle.RenderFactory;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.DataThrowable;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.core.util.Stringable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderManager
implements Render {
    static final Logger log = LoggerFactory.getLogger(RenderManager.class);
    private final Map<String, Render> _mapping = new HashMap<String, Render>();
    private Render _def = (d, c) -> {
        if (d != null) {
            c.output(d.toString());
        }
    };

    public Render get(String name) {
        return this._mapping.get(name);
    }

    public void register(RenderFactory renderFactory) {
        Render render = renderFactory.create();
        for (String mapping : renderFactory.mappings()) {
            this.register(mapping, render);
        }
    }

    public void register(Render render) {
        String[] mappings = render.mappings();
        if (mappings != null) {
            for (String mapping : mappings) {
                this.register(mapping, render);
            }
        }
    }

    public void register(String mapping, Render render) {
        if (render == null) {
            return;
        }
        if (Utils.isEmpty(mapping)) {
            this._def = render;
            log.debug("View: load: " + render.getClass().getSimpleName());
            log.debug("View: load: " + render.getClass().getName());
        } else {
            if (mapping.charAt(0) == '.') {
                this._def = render;
            }
            this._mapping.put(mapping, render);
            log.debug("Render mapping: '" + mapping + "'=" + render.name());
        }
    }

    public void register(String mapping, String clzName) {
        if (mapping == null || clzName == null) {
            return;
        }
        Render render = this._mapping.get(clzName);
        if (render == null && clzName.indexOf(46) > 0) {
            render = (Render)ClassUtil.tryInstance(clzName);
        }
        if (render == null) {
            log.warn("Render: " + clzName + " not found!");
            return;
        }
        this._mapping.put(mapping, render);
        log.debug("Render mapping: " + mapping + "=" + clzName);
    }

    @Deprecated
    public String renderAndReturn(ModelAndView modelAndView) {
        try {
            return this.renderAndReturn(modelAndView, Context.current());
        }
        catch (Throwable ex) {
            ex = Utils.throwableUnwrap(ex);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    @Override
    @Deprecated
    public String renderAndReturn(Object data, Context ctx) throws Throwable {
        Render render;
        if (data instanceof Entity && (data = ((Entity)((Object)data)).body()) instanceof String) {
            return (String)((Object)data);
        }
        if (data instanceof Stringable) {
            return data.toString();
        }
        if (data instanceof ModelAndView) {
            ModelAndView mv = (ModelAndView)((Object)data);
            if (Utils.isNotEmpty(mv.view())) {
                return this.getViewRender(ctx, mv).renderAndReturn(mv, ctx);
            }
            data = mv.model();
        }
        if ((render = this.resolveRander(ctx)) != null) {
            return render.renderAndReturn(data, ctx);
        }
        if (!ctx.remoting() && data instanceof String) {
            return (String)((Object)data);
        }
        if (render == null) {
            render = this._mapping.get("@json");
        }
        if (render != null) {
            return render.renderAndReturn(data, ctx);
        }
        return this._def.renderAndReturn(data, ctx);
    }

    @Override
    public void render(Object data, Context ctx) throws Throwable {
        if (data instanceof DataThrowable) {
            return;
        }
        if (data instanceof Entity) {
            Entity entity = (Entity)((Object)data);
            data = entity.body();
            if (!ctx.isHeadersSent()) {
                if (entity.status() > 0) {
                    ctx.status(entity.status());
                }
                if (!entity.headers().isEmpty()) {
                    for (KeyValues<String> keyValues : entity.headers()) {
                        if (!Utils.isNotEmpty(keyValues.getValues())) continue;
                        if (keyValues.getValues().size() > 1) {
                            for (String val : keyValues.getValues()) {
                                ctx.headerAdd(keyValues.getKey(), val);
                            }
                            continue;
                        }
                        ctx.headerSet(keyValues.getKey(), keyValues.getFirstValue());
                    }
                }
            }
            if (data instanceof String) {
                ctx.output((String)((Object)data));
                return;
            }
        }
        if (data instanceof Stringable) {
            ctx.output(data.toString());
            return;
        }
        if (data instanceof ModelAndView) {
            ModelAndView mv = (ModelAndView)((Object)data);
            if (Utils.isNotEmpty(mv.view())) {
                this.getViewRender(ctx, mv).render(mv, ctx);
                return;
            }
            data = mv.model();
        }
        if (data instanceof File) {
            ctx.outputAsFile((File)((Object)data));
            return;
        }
        if (data instanceof DownloadedFile) {
            ctx.outputAsFile((DownloadedFile)((Object)data));
            return;
        }
        if (data instanceof InputStream) {
            ctx.output((InputStream)((Object)data));
            return;
        }
        Render render = this.resolveRander(ctx);
        if (render != null) {
            render.render(data, ctx);
        } else if (!ctx.remoting() && data instanceof String) {
            ctx.output((String)((Object)data));
        } else {
            if (render == null) {
                render = this._mapping.get("@json");
            }
            if (render != null) {
                render.render(data, ctx);
            } else {
                this._def.render(data, ctx);
            }
        }
    }

    private Render getViewRender(Context ctx, ModelAndView mv) {
        String suffix;
        Render render;
        if (mv.view().contains("../") || mv.view().contains("..\\")) {
            throw new IllegalStateException("Invalid view path: '" + mv.view() + "'");
        }
        int suffix_idx = mv.view().lastIndexOf(".");
        if (suffix_idx > 0 && (render = this._mapping.get(suffix = mv.view().substring(suffix_idx))) != null) {
            for (Map.Entry<String, Object> kv : ctx.attrMap().entrySet()) {
                mv.putIfAbsent(kv.getKey(), kv.getValue());
            }
            return render;
        }
        return this._def;
    }

    private Render resolveRander(Context ctx) {
        Render render = null;
        String mode = ctx.header("X-Serialization");
        if (Utils.isEmpty(mode)) {
            mode = (String)ctx.attr("@render");
        }
        if (!Utils.isEmpty(mode) && (render = this._mapping.get(mode)) == null) {
            ctx.headerSet("Solon.serialization.mode", "Not supported " + mode);
        }
        if (render == null) {
            String mime2;
            String mime1 = ctx.contentTypeNew();
            if (Utils.isNotEmpty(mime1) && !mime1.startsWith("text/plain")) {
                for (Render r : this._mapping.values()) {
                    if (!r.matched(ctx, mime1)) continue;
                    render = r;
                    break;
                }
            }
            if (render == null && Utils.isNotEmpty(mime2 = ctx.acceptNew()) && !Objects.equals(mime2, mime1)) {
                for (Render r : this._mapping.values()) {
                    if (!r.matched(ctx, mime2)) continue;
                    render = r;
                    break;
                }
            }
        }
        return render;
    }

    public Render jsonOf() {
        return this.get("@json");
    }
}

