/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.route;

public class Version
implements Comparable<Version> {
    public static final Version EMPTY = new Version();
    private final int major;
    private final int minor;
    private final int patch;
    private final boolean isPattern;
    private final String original;
    private final boolean isEmpty;

    private Version() {
        this.major = 0;
        this.minor = 0;
        this.patch = 0;
        this.isPattern = false;
        this.original = "0.0.0";
        this.isEmpty = true;
    }

    public Version(String version) {
        this.original = version;
        String parsedVersion = version;
        if (version.endsWith("+")) {
            this.isPattern = true;
            parsedVersion = version.substring(0, version.length() - 1);
        } else {
            this.isPattern = false;
        }
        int[] parts = Version.parseVersionParts(parsedVersion);
        this.major = parts[0];
        this.minor = parts[1];
        this.patch = parts[2];
        this.isEmpty = this.major == 0 && this.minor == 0 && this.patch == 0 && !this.isPattern;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    private static int[] parseVersionParts(String version) {
        int[] parts = new int[]{0, 0, 0};
        if (version.isEmpty()) {
            return parts;
        }
        int partIndex = 0;
        int start = 0;
        int length = version.length();
        for (int i = 0; i < length && partIndex < 3; ++i) {
            char c = version.charAt(i);
            if (c != '.') continue;
            if (i > start) {
                parts[partIndex] = Version.fastParseInt(version, start, i);
            }
            ++partIndex;
            start = i + 1;
        }
        if (start < length && partIndex < 3) {
            parts[partIndex] = Version.fastParseInt(version, start, length);
        }
        return parts;
    }

    private static int fastParseInt(String s, int start, int end) {
        char c;
        int result = 0;
        for (int i = start; i < end && (c = s.charAt(i)) >= '0' && c <= '9'; ++i) {
            result = result * 10 + (c - 48);
        }
        return result;
    }

    public boolean includes(Version requestVersion) {
        if (requestVersion == null || requestVersion.isEmpty()) {
            return true;
        }
        if (!this.isPattern) {
            return this.compareTo(requestVersion) == 0;
        }
        int majorDiff = Integer.compare(this.major, requestVersion.major);
        if (majorDiff != 0) {
            return majorDiff <= 0;
        }
        int minorDiff = Integer.compare(this.minor, requestVersion.minor);
        if (minorDiff != 0) {
            return minorDiff <= 0;
        }
        int patchDiff = Integer.compare(this.patch, requestVersion.patch);
        if (patchDiff != 0) {
            return patchDiff <= 0;
        }
        return true;
    }

    @Override
    public int compareTo(Version other) {
        if (other == null || other.isEmpty()) {
            return -1;
        }
        int majorDiff = Integer.compare(other.major, this.major);
        if (majorDiff != 0) {
            return majorDiff;
        }
        int minorDiff = Integer.compare(other.minor, this.minor);
        if (minorDiff != 0) {
            return minorDiff;
        }
        int patchDiff = Integer.compare(other.patch, this.patch);
        if (patchDiff == 0 && other.isPattern != this.isPattern) {
            if (this.isPattern) {
                return -1;
            }
            return 1;
        }
        return patchDiff;
    }

    public String toString() {
        return this.original;
    }

    public String getOriginal() {
        return this.original;
    }
}

