/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.route;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.Result;
import org.noear.solon.core.route.Routing;
import org.noear.solon.core.route.RoutingDefault;
import org.noear.solon.core.route.RoutingTable;
import org.noear.solon.core.route.Version;
import org.noear.solon.core.util.Assert;
import org.noear.solon.core.util.RankEntity;

public class RoutingTableDefault<T>
implements RoutingTable<T> {
    private final LinkedList<RankEntity<Routing<T>>> table = new LinkedList();
    private final Map<String, RoutingDefault<T>> routingCache = new ConcurrentHashMap<String, RoutingDefault<T>>();
    private final Map<String, Version> versionCache = new ConcurrentHashMap<String, Version>();

    private Version versionOf(String versionStr) {
        if (Assert.isEmpty(versionStr)) {
            return null;
        }
        return this.versionCache.computeIfAbsent(versionStr, Version::new);
    }

    @Override
    public void add(String path, MethodType method, int index, String versionStr, T target) {
        String key = path + ":" + method.name;
        this.routingCache.computeIfAbsent(key, k -> {
            RoutingDefault routing = new RoutingDefault(path, method, index);
            this.doAdd(routing);
            return routing;
        }).addVersionTarget(this.versionOf(versionStr), target);
    }

    private void doAdd(Routing<T> routing) {
        int level = 0;
        if (routing.globstar() == 0) {
            level = 4;
        } else if (routing.globstar() > 0) {
            level = 3;
        } else if (routing.path().indexOf(42) >= 0) {
            level = 2;
        } else if (routing.path().indexOf(123) >= 0) {
            level = 1;
        }
        RankEntity<Routing<T>> entity = new RankEntity<Routing<T>>(routing, level, routing.index(), false);
        if (level != 0 || routing.index() != 0) {
            this.table.addLast(entity);
            Collections.sort(this.table);
        } else {
            this.table.addFirst(entity);
        }
    }

    @Override
    public void remove(String pathPrefix) {
        this.table.removeIf(l -> {
            if (((Routing)l.target).path().startsWith(pathPrefix)) {
                this.routingCache.remove(((Routing)l.target).path() + ":" + ((Routing)l.target).method().name());
                return true;
            }
            return false;
        });
    }

    @Override
    public void remove(Class<?> controllerClz) {
        this.table.removeIf(l -> {
            ((Routing)l.target).targets().removeIf(vt -> {
                Action a;
                return vt.getTarget() instanceof Action && (a = (Action)vt.getTarget()).controller().clz().equals(controllerClz);
            });
            return ((Routing)l.target).targets().size() == 0;
        });
    }

    @Override
    public int count() {
        return this.table.size();
    }

    @Override
    public Collection<Routing<T>> getAll() {
        return this.table.stream().map(l -> (Routing)l.target).collect(Collectors.toList());
    }

    @Override
    public Collection<Routing<T>> getBy(String pathPrefix) {
        return this.table.stream().filter(l -> ((Routing)l.target).path().startsWith(pathPrefix)).map(l -> (Routing)l.target).collect(Collectors.toList());
    }

    @Override
    public Collection<Routing<T>> getBy(Class<?> controllerClz) {
        return this.table.stream().filter(l -> ((Routing)l.target).targets().stream().anyMatch(vt -> {
            Action a;
            return vt.getTarget() instanceof Action && (a = (Action)vt.getTarget()).controller().clz().equals(controllerClz);
        })).map(l -> (Routing)l.target).collect(Collectors.toList());
    }

    @Override
    public T matchOne(String path, String versionStr, MethodType method) {
        Version version2 = this.versionOf(versionStr);
        for (RankEntity rankEntity : this.table) {
            if (!((Routing)rankEntity.target).matches(method, path)) continue;
            return ((Routing)rankEntity.target).target(version2);
        }
        return null;
    }

    @Override
    public Result<T> matchOneAndStatus(String path, String versionStr, MethodType method) {
        Version version2 = this.versionOf(versionStr);
        int degrees = 0;
        for (RankEntity rankEntity : this.table) {
            int tmp = ((Routing)rankEntity.target).degrees(method, path);
            if (tmp == 2) {
                return Result.succeed(((Routing)rankEntity.target).target(version2));
            }
            if (tmp <= degrees) continue;
            degrees = tmp;
        }
        if (degrees == 1) {
            return Result.failure(405);
        }
        return Result.failure(404);
    }

    @Override
    public List<T> matchMore(String path, String versionStr, MethodType method) {
        Version version2 = this.versionOf(versionStr);
        return this.table.stream().filter(l -> ((Routing)l.target).matches(method, path)).map(l -> ((Routing)l.target).target(version2)).collect(Collectors.toList());
    }

    @Override
    public void clear() {
        this.table.clear();
    }
}

