/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.route;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.route.Routing;
import org.noear.solon.core.route.Version;
import org.noear.solon.core.route.VersionedTarget;
import org.noear.solon.core.util.PathMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingDefault<T>
implements Routing<T> {
    private static final Logger log = LoggerFactory.getLogger(RoutingDefault.class);
    private final PathMatcher rule;
    private final int index;
    private final String path;
    private final MethodType method;
    private final int globstar;
    private final boolean matchall;
    private VersionedTarget<T> versionedTargetNull;
    private TreeMap<Version, VersionedTarget<T>> versionedTargets = new TreeMap();

    public RoutingDefault(String path, MethodType method, int index) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        this.rule = PathMatcher.get(path, false);
        this.method = method;
        this.path = path;
        this.globstar = path.indexOf("/**");
        this.matchall = path.equals("/**");
        this.index = index;
    }

    public RoutingDefault<T> addVersionTarget(Version version, T target) {
        if (version == null) {
            version = Version.EMPTY;
        }
        VersionedTarget<T> tmp = new VersionedTarget<T>(version, target);
        if (version.isEmpty()) {
            if (this.versionedTargetNull != null) {
                log.warn("The routing replaced: '{}'", (Object)this.path);
            }
            this.versionedTargetNull = tmp;
        } else if (this.versionedTargets.containsKey(version)) {
            log.warn("The routing version({}) replaced: '{}'", (Object)version.getOriginal(), (Object)this.path);
        }
        this.versionedTargets.put(version, tmp);
        return this;
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public int globstar() {
        return this.globstar;
    }

    @Override
    public Collection<VersionedTarget<T>> targets() {
        return this.versionedTargets.values();
    }

    @Override
    public T target(Version version2) {
        VersionedTarget<T> exact;
        if (version2 == null) {
            if (this.versionedTargetNull != null) {
                return this.versionedTargetNull.getTarget();
            }
            version2 = Version.EMPTY;
        }
        if ((exact = this.versionedTargets.get(version2)) != null) {
            return exact.getTarget();
        }
        for (Map.Entry<Version, VersionedTarget<T>> entry : this.versionedTargets.entrySet()) {
            if (!entry.getKey().includes(version2)) continue;
            return entry.getValue().getTarget();
        }
        return null;
    }

    @Override
    public MethodType method() {
        return this.method;
    }

    @Override
    public boolean matches(MethodType method2, String path2) {
        if (MethodType.ALL == this.method) {
            return this.matches0(path2);
        }
        if (MethodType.HTTP == this.method ? method2.signal == SignalType.HTTP : method2 == this.method) {
            return this.matches0(path2);
        }
        return false;
    }

    @Override
    public int degrees(MethodType method2, String path2) {
        if (this.matches0(path2)) {
            if (MethodType.ALL == this.method) {
                return 2;
            }
            if (MethodType.HTTP == this.method ? method2.signal == SignalType.HTTP : method2 == this.method) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public boolean test(String path2) {
        return this.matches0(path2);
    }

    private boolean matches0(String path2) {
        if (this.matchall) {
            return true;
        }
        if (this.path.equals(path2)) {
            return true;
        }
        return this.rule.matches(path2);
    }

    public String toString() {
        return "Routing{index=" + this.index + ", method=" + (Object)((Object)this.method) + ", path='" + this.path + '\'' + '}';
    }
}

