/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.route;

import org.noear.solon.SolonApp;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.ChainManager;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.route.Router;
import org.noear.solon.core.route.RouterDefault;
import org.noear.solon.core.route.RouterHandler;
import org.noear.solon.core.route.RouterInterceptor;

public abstract class RouterWrapper {
    private Router _router;
    private RouterHandler _routerHandler;
    private ChainManager _chainManager;
    private SolonApp _app;

    public abstract AppContext context();

    protected void initRouter(SolonApp app) {
        this._app = app;
        this._chainManager = new ChainManager(app);
        this._router = new RouterDefault(this._chainManager);
        this._routerHandler = new RouterHandler(this._router, this._chainManager);
    }

    public RouterHandler routerHandler() {
        return this._routerHandler;
    }

    public Router router() {
        return this._router;
    }

    @Deprecated
    public ChainManager chainManager() {
        return this.chains();
    }

    public ChainManager chains() {
        return this._chainManager;
    }

    @Deprecated
    public void filter(Filter filter) {
        this.filter(0, filter);
    }

    @Deprecated
    public void filter(int index, Filter filter) {
        this._router.filter(index, filter);
    }

    @Deprecated
    public void filterIfAbsent(int index, Filter filter) {
        this._router.filterIfAbsent(index, filter);
    }

    @Deprecated
    public void routerInterceptor(RouterInterceptor interceptor) {
        this._router.routerInterceptor(interceptor);
    }

    @Deprecated
    public void routerInterceptor(int index, RouterInterceptor interceptor) {
        this._router.routerInterceptor(index, interceptor);
    }

    @Deprecated
    public void routerInterceptorIfAbsent(int index, RouterInterceptor interceptor) {
        this._router.routerInterceptorIfAbsent(index, interceptor);
    }

    @Deprecated
    public void render(String name, Render render) {
        this._app.renders().register(name, render);
    }

    @Deprecated
    public Render render(String name) {
        return this._app.renders().get(name);
    }

    @Deprecated
    public Render renderOfJson() {
        return this._app.renders().get("@json");
    }

    @Deprecated
    public void add(String pathPrefix, Class<?> clz) {
        BeanWrap bw = this.context().wrapAndPut(clz);
        this._router.add(pathPrefix, bw);
    }

    @Deprecated
    public void add(String pathPrefix, Class<?> clz, boolean remoting) {
        BeanWrap bw = this.context().wrapAndPut(clz);
        bw.remotingSet(remoting);
        this._router.add(pathPrefix, bw);
    }

    @Deprecated
    public void add(String path, MethodType method, Handler handler) {
        this._router.add(path, method, handler);
    }

    @Deprecated
    public void add(String path, MethodType method, int index, Handler handler) {
        this._router.add(path, method, index, handler);
    }

    @Deprecated
    public void all(String path, Handler handler) {
        this.add(path, MethodType.ALL, handler);
    }

    @Deprecated
    public void http(String path, Handler handler) {
        this.add(path, MethodType.HTTP, handler);
    }

    @Deprecated
    public void head(String path, Handler handler) {
        this.add(path, MethodType.HEAD, handler);
    }

    @Deprecated
    public void get(String path, Handler handler) {
        this.add(path, MethodType.GET, handler);
    }

    @Deprecated
    public void post(String path, Handler handler) {
        this.add(path, MethodType.POST, handler);
    }

    @Deprecated
    public void put(String path, Handler handler) {
        this.add(path, MethodType.PUT, handler);
    }

    @Deprecated
    public void patch(String path, Handler handler) {
        this.add(path, MethodType.PATCH, handler);
    }

    @Deprecated
    public void delete(String path, Handler handler) {
        this.add(path, MethodType.DELETE, handler);
    }

    @Deprecated
    public void socketd(String path, Handler handler) {
        this.add(path, MethodType.SOCKET, handler);
    }
}

