/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.Properties;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.lang.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginEntity
implements Comparable<PluginEntity> {
    static final Logger log = LoggerFactory.getLogger(PluginEntity.class);
    private String className;
    private ClassLoader classLoader;
    private int priority = 0;
    private Plugin plugin;
    private Properties props;

    public PluginEntity(ClassLoader classLoader, String className, Properties props) {
        this.classLoader = classLoader;
        this.className = className;
        this.props = props;
    }

    public PluginEntity(Plugin plugin) {
        this.plugin = plugin;
    }

    public PluginEntity(Plugin plugin, int priority) {
        this.plugin = plugin;
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public @Nullable Plugin getPlugin() {
        return this.plugin;
    }

    public Properties getProps() {
        return this.props;
    }

    public String getClassName() {
        return this.className;
    }

    public void init(AppContext context) {
        this.initInstance(context);
    }

    public void start(AppContext context) {
        if (this.plugin != null) {
            try {
                this.plugin.start(context);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new IllegalStateException("The plugin start failed: " + this.className, e);
            }
        }
    }

    @Deprecated
    public void prestop() {
        this.preStop();
    }

    public void preStop() {
        if (this.plugin != null) {
            try {
                this.plugin.preStop();
            }
            catch (Throwable e) {
                log.warn("The plugin preStop failed: {}", (Object)this.className, (Object)e);
            }
        }
    }

    public void stop() {
        if (this.plugin != null) {
            try {
                this.plugin.stop();
            }
            catch (Throwable e) {
                log.warn("The plugin stop failed: {}", (Object)this.className, (Object)e);
            }
        }
    }

    private void initInstance(AppContext context) {
        if (this.plugin == null && this.classLoader != null) {
            this.plugin = (Plugin)ClassUtil.tryInstance(this.classLoader, this.className);
            if (this.plugin == null) {
                log.warn("The configured plugin cannot load: " + this.className);
            }
        }
    }

    public String toString() {
        return "PluginEntity{priority=" + this.priority + ", className='" + this.className + '\'' + '}';
    }

    @Override
    public int compareTo(PluginEntity o) {
        if (this.priority == o.priority) {
            return 0;
        }
        if (this.priority > o.priority) {
            return -1;
        }
        return 1;
    }
}

