/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.wrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.util.function.Supplier;
import org.noear.eggg.FieldEggg;
import org.noear.eggg.TypeEggg;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.InjectGather;
import org.noear.solon.core.VarHolder;

public class VarHolderOfField
implements VarHolder {
    private final FieldEggg fe;
    private final ParameterizedType pType;
    private final Object obj;
    private final AppContext ctx;
    private Class<?> dependencyType;
    private Object val;
    private Supplier valDef;
    private boolean required = false;
    private boolean done;
    private InjectGather gather;

    public VarHolderOfField(AppContext ctx, FieldEggg fe, Object obj, InjectGather gather) {
        this.ctx = ctx;
        this.fe = fe;
        this.obj = obj;
        this.gather = gather;
        this.pType = fe.getTypeEggg().isParameterizedType() ? fe.getTypeEggg().getParameterizedType() : null;
    }

    @Override
    public AppContext context() {
        return this.ctx;
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public TypeEggg getTypeEggg() {
        return this.fe.getTypeEggg();
    }

    @Override
    public Class<?> getType() {
        return this.fe.getTypeEggg().getType();
    }

    @Override
    public ParameterizedType getGenericType() {
        return this.pType;
    }

    @Override
    public Class<?> getDependencyType() {
        if (this.dependencyType == null) {
            return this.getType();
        }
        return this.dependencyType;
    }

    @Override
    public void setDependencyType(Class<?> dependencyType) {
        this.dependencyType = dependencyType;
    }

    @Override
    public Annotation[] getAnnoS() {
        return this.fe.getAnnotations();
    }

    @Override
    public String getFullName() {
        Class<?> declClz;
        Class<?> fileClz = declClz = this.fe.getField().getDeclaringClass();
        if (declClz.isMemberClass()) {
            fileClz = declClz.getEnclosingClass();
        }
        StringBuilder buf = new StringBuilder();
        buf.append("'").append(this.fe.getName()).append("'");
        buf.append("\r\n\tat ").append(declClz.getName()).append(".").append(this.fe.getName()).append("(").append(fileClz.getSimpleName()).append(".java:0)");
        if (declClz != this.fe.getOwnerEggg().getType()) {
            buf.append("\r\n\tat ").append(this.fe.getOwnerEggg().getType().getName());
        }
        return buf.toString();
    }

    @Override
    public void setValue(Object val) {
        if (val != null) {
            this.fe.setValue(this.obj, val, false);
            this.ctx.aot().registerJdkProxyType(this.getType(), val);
        }
        this.val = val;
        this.done = true;
        if (this.gather != null) {
            this.gather.run();
        }
    }

    @Override
    public void setValueDefault(Supplier supplier) {
        this.valDef = supplier;
    }

    @Override
    public Object getValue() {
        if (this.val == null && this.valDef != null) {
            return this.valDef.get();
        }
        return this.val;
    }

    @Override
    public void commit() {
        Object tmp;
        if (this.isDone()) {
            return;
        }
        if (this.valDef != null && (tmp = this.valDef.get()) != null) {
            this.setValue(tmp);
        }
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean required() {
        return this.required;
    }

    @Override
    public void required(boolean required) {
        this.required = required;
    }

    public String toString() {
        if (this.fe.getGenericType() == null) {
            return this.fe.getName() + ":" + this.fe.getType().getTypeName();
        }
        return this.fe.getName() + ":" + this.fe.getGenericType().getTypeName();
    }
}

