/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.runtime;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Set;
import org.noear.eggg.MethodEggg;
import org.noear.solon.core.runtime.NativeDetector;

public class AotCollector {
    private final Set<Class<?>> entityTypes = new LinkedHashSet();
    private final Set<Class<?>> jdkProxyTypes = new LinkedHashSet();
    private final Set<MethodEggg> methodEgggs = new LinkedHashSet<MethodEggg>();

    public Set<Class<?>> getEntityTypes() {
        return this.entityTypes;
    }

    public Set<Class<?>> getJdkProxyTypes() {
        return this.jdkProxyTypes;
    }

    public Set<MethodEggg> getMethodEgggs() {
        return this.methodEgggs;
    }

    public void registerEntityType(Class<?> type, Type genericType) {
        if (NativeDetector.isAotRuntime()) {
            if (!type.getName().startsWith("java.")) {
                this.entityTypes.add(type);
            }
            if (genericType instanceof ParameterizedType) {
                ParameterizedType genericType1 = (ParameterizedType)genericType;
                for (Type type1 : genericType1.getActualTypeArguments()) {
                    if (!(type1 instanceof Class) || type1.getTypeName().startsWith("java.")) continue;
                    this.entityTypes.add((Class)type1);
                }
            }
        }
    }

    public void registerJdkProxyType(Class<?> type, Object target) {
        if (NativeDetector.isAotRuntime() && Proxy.isProxyClass(target.getClass()) && !type.getName().startsWith("java.")) {
            this.jdkProxyTypes.add(type);
        }
    }

    public void registerMethodEggg(MethodEggg methodEggg) {
        this.methodEgggs.add(methodEggg);
    }

    public void clear() {
        this.entityTypes.clear();
        this.jdkProxyTypes.clear();
    }
}

